/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk.message.convert.request;

import com.eway.payment.rapid.sdk.beans.external.CardDetails;
import com.eway.payment.rapid.sdk.beans.external.LineItem;
import com.eway.payment.rapid.sdk.beans.external.Refund;
import com.eway.payment.rapid.sdk.beans.internal.Customer;
import com.eway.payment.rapid.sdk.beans.internal.Option;
import com.eway.payment.rapid.sdk.beans.internal.ShippingAddress;
import com.eway.payment.rapid.sdk.entities.DirectRefundRequest;
import com.eway.payment.rapid.sdk.exception.RapidSdkException;
import com.eway.payment.rapid.sdk.message.convert.BeanConverter;
import com.eway.payment.rapid.sdk.message.convert.CustomerToInternalCustomerConverter;
import com.eway.payment.rapid.sdk.message.convert.ShippingDetailsToAddressConverter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefundToDirectRefundReqConverter
implements BeanConverter<Refund, DirectRefundRequest> {
    @Override
    public DirectRefundRequest doConvert(Refund refund) throws RapidSdkException {
        DirectRefundRequest request = new DirectRefundRequest();
        if (refund != null) {
            List<String> listOptions;
            request.setRefund(refund.getRefundDetails());
            ShippingDetailsToAddressConverter shippingConvert = new ShippingDetailsToAddressConverter();
            request.setShippingAddress((ShippingAddress)shippingConvert.doConvert(refund.getShippingDetails()));
            CustomerToInternalCustomerConverter customerConvert = new CustomerToInternalCustomerConverter();
            Customer customer = customerConvert.doConvert(refund.getCustomer());
            if (customer.getCardDetails() == null) {
                customer.setCardDetails(new CardDetails());
            }
            request.setCustomer(customer);
            request.setPartnerID(refund.getPartnerID());
            request.setDeviceID(refund.getDeviceID());
            List<LineItem> lineItems = refund.getLineItems();
            if (lineItems != null) {
                LineItem[] items = lineItems.toArray(new LineItem[lineItems.size()]);
                request.setItems(items);
            }
            if ((listOptions = refund.getOptions()) != null && !listOptions.isEmpty()) {
                ArrayList<Option> listConvert = new ArrayList<Option>();
                for (String value : listOptions) {
                    Option op = new Option();
                    op.setValue(value);
                    listConvert.add(op);
                }
                request.setOptions(listConvert.toArray(new Option[listConvert.size()]));
            }
        }
        return request;
    }
}

