/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk.message.convert.request;

import com.eway.payment.rapid.sdk.beans.external.LineItem;
import com.eway.payment.rapid.sdk.beans.external.RequestMethod;
import com.eway.payment.rapid.sdk.beans.external.Transaction;
import com.eway.payment.rapid.sdk.beans.internal.Customer;
import com.eway.payment.rapid.sdk.beans.internal.Option;
import com.eway.payment.rapid.sdk.beans.internal.Payment;
import com.eway.payment.rapid.sdk.beans.internal.ShippingAddress;
import com.eway.payment.rapid.sdk.entities.CreateAccessCodeSharedRequest;
import com.eway.payment.rapid.sdk.exception.RapidSdkException;
import com.eway.payment.rapid.sdk.message.convert.BeanConverter;
import com.eway.payment.rapid.sdk.message.convert.CustomerToInternalCustomerConverter;
import com.eway.payment.rapid.sdk.message.convert.TransactionShippingAddressConverter;
import com.eway.payment.rapid.sdk.message.convert.TransactionToArrLineItemConverter;
import com.eway.payment.rapid.sdk.message.convert.TransactionToArrOptionConverter;
import com.eway.payment.rapid.sdk.message.convert.TransactionToPaymentConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionToCreateAccessCodeSharedRequestConverter
implements BeanConverter<Transaction, CreateAccessCodeSharedRequest> {
    @Override
    public CreateAccessCodeSharedRequest doConvert(Transaction input) throws RapidSdkException {
        CreateAccessCodeSharedRequest request = new CreateAccessCodeSharedRequest();
        if (input != null) {
            request.setCancelUrl(input.getCancelURL());
            request.setTransactionType(input.getTransactionType().name());
            request.setDeviceID(input.getDeviceID());
            request.setPartnerID(input.getPartnerID());
            request.setRedirectUrl(input.getRedirectURL());
            request.setCustomView(input.getCustomView());
            request.setHeaderText(input.getHeaderText());
            request.setCustomerIP(input.getCustomer() != null ? input.getCustomer().getCustomerDeviceIP() : null);
            request.setLogoUrl(input.getLogoUrl());
            request.setLanguage(input.getLanguage());
            request.setVerifyCustomerEmail(input.getVerifyCustomerEmail());
            request.setVerifyCustomerPhone(input.getVerifyCustomerPhone());
            request.setCustomerReadOnly(input.getCustomerReadOnly());
            CustomerToInternalCustomerConverter internalCustConvert = new CustomerToInternalCustomerConverter();
            request.setCustomer((Customer)internalCustConvert.doConvert(input.getCustomer()));
            TransactionShippingAddressConverter shipAddressConvert = new TransactionShippingAddressConverter();
            request.setShippingAddress((ShippingAddress)shipAddressConvert.doConvert(input));
            TransactionToPaymentConverter paymentConvert = new TransactionToPaymentConverter();
            request.setPayment((Payment)paymentConvert.doConvert(input));
            TransactionToArrLineItemConverter lineItemConvert = new TransactionToArrLineItemConverter();
            request.setItems((LineItem[])lineItemConvert.doConvert(input));
            TransactionToArrOptionConverter optionConverter = new TransactionToArrOptionConverter();
            request.setOptions((Option[])optionConverter.doConvert(input));
            request.setMethod(input.isCapture() ? (input.isSaveCustomer() ? RequestMethod.TokenPayment.name() : RequestMethod.ProcessPayment.name()) : RequestMethod.Authorise.name());
        }
        return request;
    }
}

