/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk.message.convert.response;

import com.eway.payment.rapid.sdk.beans.external.Customer;
import com.eway.payment.rapid.sdk.beans.external.PaymentDetails;
import com.eway.payment.rapid.sdk.beans.external.Transaction;
import com.eway.payment.rapid.sdk.entities.CreateAccessCodeSharedResponse;
import com.eway.payment.rapid.sdk.exception.RapidSdkException;
import com.eway.payment.rapid.sdk.message.convert.BeanConverter;
import com.eway.payment.rapid.sdk.message.convert.InternalCustomerToCustomerConverter;
import com.eway.payment.rapid.sdk.message.convert.PaymentToPaymentDetailsConverter;
import com.eway.payment.rapid.sdk.output.CreateTransactionResponse;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessCodeSharedToCreateTransConverter
implements BeanConverter<CreateAccessCodeSharedResponse, CreateTransactionResponse> {
    @Override
    public CreateTransactionResponse doConvert(CreateAccessCodeSharedResponse response) throws RapidSdkException {
        CreateTransactionResponse transactionResponse = new CreateTransactionResponse();
        Transaction transaction = new Transaction();
        InternalCustomerToCustomerConverter custConvert = new InternalCustomerToCustomerConverter();
        transaction.setCustomer((Customer)custConvert.doConvert(response.getCustomer()));
        PaymentToPaymentDetailsConverter paymentConverter = new PaymentToPaymentDetailsConverter();
        transaction.setPaymentDetails((PaymentDetails)paymentConverter.doConvert(response.getPayment()));
        transactionResponse.setTransaction(transaction);
        if (!StringUtils.isBlank((CharSequence)response.getErrors())) {
            transactionResponse.setErrors(Arrays.asList(response.getErrors().split("\\s*,\\s*")));
        }
        transactionResponse.setSharedPaymentUrl(response.getSharedPaymentUrl());
        transactionResponse.setAccessCode(response.getAccessCode());
        return transactionResponse;
    }
}

