/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk.message.convert.response;

import com.eway.payment.rapid.sdk.beans.external.ProcessingDetails;
import com.eway.payment.rapid.sdk.beans.external.Refund;
import com.eway.payment.rapid.sdk.beans.external.TransactionStatus;
import com.eway.payment.rapid.sdk.entities.CancelAuthorisationResponse;
import com.eway.payment.rapid.sdk.exception.RapidSdkException;
import com.eway.payment.rapid.sdk.message.convert.BeanConverter;
import com.eway.payment.rapid.sdk.output.RefundResponse;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancelAuthorisationToRefundConverter
implements BeanConverter<CancelAuthorisationResponse, RefundResponse> {
    private Refund refund;

    public CancelAuthorisationToRefundConverter(Refund refund) {
        this.refund = refund;
    }

    @Override
    public RefundResponse doConvert(CancelAuthorisationResponse cancel) throws RapidSdkException {
        RefundResponse response = new RefundResponse();
        response.setRefund(this.refund);
        TransactionStatus status = new TransactionStatus();
        status.setStatus(cancel.getTransactionStatus());
        ProcessingDetails detail = new ProcessingDetails();
        detail.setResponseCode(cancel.getErrors());
        detail.setResponseCode(cancel.getResponseCode());
        status.setProcessingDetails(detail);
        status.setTransactionID(Integer.parseInt(cancel.getTransactionID()));
        response.setTransactionStatus(status);
        if (!StringUtils.isBlank((CharSequence)cancel.getErrors())) {
            response.getErrors().addAll(Arrays.asList(cancel.getErrors().split("\\s*,\\s*")));
        }
        return response;
    }
}

