/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk.message.convert.response;

import com.eway.payment.rapid.sdk.beans.internal.Customer;
import com.eway.payment.rapid.sdk.entities.DirectCustomerSearchResponse;
import com.eway.payment.rapid.sdk.message.convert.BeanConverter;
import com.eway.payment.rapid.sdk.output.QueryCustomerResponse;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectCustomerToQueryCustomerConverter
implements BeanConverter<DirectCustomerSearchResponse, QueryCustomerResponse> {
    @Override
    public QueryCustomerResponse doConvert(DirectCustomerSearchResponse response) {
        QueryCustomerResponse result = new QueryCustomerResponse();
        if (response != null) {
            Iterator<Customer> iterator;
            List<Customer> list;
            if (!StringUtils.isBlank((CharSequence)response.getErrors())) {
                result.setErrors(Arrays.asList(response.getErrors()));
            }
            if ((list = response.getCustomers()) != null && list.size() > 0 && (iterator = list.iterator()).hasNext()) {
                Customer cust = iterator.next();
                result.setReference(cust.getReference());
                result.setTitle(cust.getTitle());
                result.setFirstName(cust.getFirstName());
                result.setLastName(cust.getLastName());
                result.setCompanyName(cust.getCompanyName());
                result.setJobDescription(cust.getJobDescription());
                String street = cust.getStreet1();
                if (!StringUtils.isBlank((CharSequence)street)) {
                    int splitIndex = street.lastIndexOf(",");
                    if (splitIndex > -1) {
                        result.setStreet1(street.substring(0, splitIndex));
                        result.setStreet2(street.substring(splitIndex + 1, street.length()).trim());
                    } else {
                        result.setStreet1(street);
                    }
                }
                result.setCity(cust.getCity());
                result.setState(cust.getState());
                result.setPostalCode(cust.getPostalCode());
                result.setPhone(cust.getPhone());
                result.setMobile(cust.getMobile());
                result.setEmail(cust.getEmail());
                result.setUrl(cust.getUrl());
                result.setCardDetail(cust.getCardDetails());
                result.setCountry(cust.getCountry());
                result.setComments(cust.getComments());
                result.setFax(cust.getFax());
                return result;
            }
        }
        return result;
    }
}

