/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk.message.convert.response;

import com.eway.payment.rapid.sdk.beans.external.Refund;
import com.eway.payment.rapid.sdk.beans.external.TransactionStatus;
import com.eway.payment.rapid.sdk.beans.internal.Customer;
import com.eway.payment.rapid.sdk.entities.DirectRefundResponse;
import com.eway.payment.rapid.sdk.exception.RapidSdkException;
import com.eway.payment.rapid.sdk.message.convert.BeanConverter;
import com.eway.payment.rapid.sdk.message.convert.DirectRefundToTransStatusConverter;
import com.eway.payment.rapid.sdk.message.convert.InternalCustomerToCustomerConverter;
import com.eway.payment.rapid.sdk.output.RefundResponse;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectRefundToRefundResponseConverter
implements BeanConverter<DirectRefundResponse, RefundResponse> {
    @Override
    public RefundResponse doConvert(DirectRefundResponse response) throws RapidSdkException {
        Refund refund = new Refund();
        refund.setRefundDetails(response.getRefund());
        Customer innerCust = response.getCustomer();
        InternalCustomerToCustomerConverter custConvert = new InternalCustomerToCustomerConverter();
        refund.setCustomer((com.eway.payment.rapid.sdk.beans.external.Customer)custConvert.doConvert(innerCust));
        RefundResponse refundResponse = new RefundResponse();
        if (!StringUtils.isBlank((CharSequence)response.getErrors())) {
            refundResponse.setErrors(Arrays.asList(response.getErrors().split("\\s*,\\s*")));
        }
        refundResponse.setRefund(refund);
        DirectRefundToTransStatusConverter transStatusConvert = new DirectRefundToTransStatusConverter();
        refundResponse.setTransactionStatus((TransactionStatus)transStatusConvert.doConvert(response));
        return refundResponse;
    }
}

