/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk.message.process;

import com.eway.payment.rapid.sdk.entities.Response;
import com.eway.payment.rapid.sdk.exception.AuthenticationFailureException;
import com.eway.payment.rapid.sdk.exception.CommunicationFailureException;
import com.eway.payment.rapid.sdk.exception.RapidSdkException;
import com.eway.payment.rapid.sdk.exception.SystemErrorException;
import com.eway.payment.rapid.sdk.message.process.MessageProcess;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageProcess<T, V>
implements MessageProcess<T, V> {
    private WebResource webResource;
    private T t;
    private final List<String> listRequestPath = new ArrayList<String>();
    public String requestJson;

    public AbstractMessageProcess(WebResource resource, String ... requestPath) {
        this.webResource = resource;
        if (requestPath != null) {
            this.listRequestPath.addAll(Arrays.asList(requestPath));
        }
    }

    @Override
    public final V doWork(T input) throws RapidSdkException {
        this.t = input;
        Response response = this.processPostMsg(input);
        if (response != null) {
            return this.makeResult(response);
        }
        throw new SystemErrorException("Response object is null");
    }

    protected final <U, K> U doPost(K request, Class<U> responseClass) throws RapidSdkException {
        try {
            WebResource resouce = this.getWebResource();
            for (String path : this.getRequestPath()) {
                if (StringUtils.isBlank((CharSequence)path)) continue;
                resouce = resouce.path(path);
            }
            ObjectMapper mapper = new ObjectMapper();
            this.requestJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(request);
            return (U)((WebResource.Builder)resouce.type(MediaType.APPLICATION_JSON_TYPE).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).post(responseClass, request);
        }
        catch (ClientHandlerException e) {
            throw new CommunicationFailureException("Internal system error communicating with Rapid API", e);
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getStatus() == ClientResponse.Status.UNAUTHORIZED.getStatusCode()) {
                throw new AuthenticationFailureException("Authentication failed on the endpoint", e);
            }
            if (e.getResponse().getStatus() == ClientResponse.Status.FORBIDDEN.getStatusCode()) {
                throw new AuthenticationFailureException("Authentication failed on the endpoint", e);
            }
            if (e.getResponse().getStatus() == ClientResponse.Status.NOT_FOUND.getStatusCode()) {
                throw new AuthenticationFailureException("Authentication failed on the endpoint", e);
            }
            throw new SystemErrorException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SystemErrorException(e.getMessage(), e);
        }
    }

    protected final <U, K> U doPut(K request, Class<U> responseClass) throws RapidSdkException {
        try {
            WebResource resouce = this.getWebResource();
            for (String path : this.getRequestPath()) {
                if (StringUtils.isBlank((CharSequence)path)) continue;
                resouce = resouce.path(path);
            }
            ObjectMapper mapper = new ObjectMapper();
            this.requestJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(request);
            return (U)((WebResource.Builder)resouce.type(MediaType.APPLICATION_JSON_TYPE).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).put(responseClass, request);
        }
        catch (ClientHandlerException e) {
            throw new CommunicationFailureException("Internal system error communicating with Rapid API", e);
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getStatus() == ClientResponse.Status.UNAUTHORIZED.getStatusCode()) {
                throw new AuthenticationFailureException("Authentication failed on the endpoint", e);
            }
            if (e.getResponse().getStatus() == ClientResponse.Status.FORBIDDEN.getStatusCode()) {
                throw new AuthenticationFailureException("Authentication failed on the endpoint", e);
            }
            if (e.getResponse().getStatus() == ClientResponse.Status.NOT_FOUND.getStatusCode()) {
                throw new AuthenticationFailureException("Authentication failed on the endpoint", e);
            }
            throw new SystemErrorException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SystemErrorException(e.getMessage(), e);
        }
    }

    protected final <U> U doGet(String request, Class<U> responseClass) throws RapidSdkException {
        WebResource resouce = this.getWebResource();
        for (String p : this.getRequestPath()) {
            if (StringUtils.isBlank((CharSequence)p)) continue;
            resouce = resouce.path(p);
        }
        try {
            return (U)resouce.path(request).get(responseClass);
        }
        catch (ClientHandlerException e) {
            throw new CommunicationFailureException("Internal system error communicating with Rapid API", e);
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getStatus() == ClientResponse.Status.UNAUTHORIZED.getStatusCode()) {
                throw new AuthenticationFailureException("Authentication failed on the endpoint", e);
            }
            if (e.getResponse().getStatus() == ClientResponse.Status.FORBIDDEN.getStatusCode()) {
                throw new AuthenticationFailureException("Authentication failed on the endpoint", e);
            }
            if (e.getResponse().getStatus() == ClientResponse.Status.NOT_FOUND.getStatusCode()) {
                throw new AuthenticationFailureException("Authentication failed on the endpoint", e);
            }
            throw new SystemErrorException(e.getMessage(), e);
        }
    }

    protected final T getInput() {
        return this.t;
    }

    protected final List<String> getRequestPath() {
        return this.listRequestPath;
    }

    protected final void addRequestPath(String ... requestPath) {
        if (requestPath != null) {
            for (String path : requestPath) {
                if (StringUtils.isBlank((CharSequence)path)) continue;
                this.listRequestPath.add(path);
            }
        }
    }

    protected abstract Response processPostMsg(T var1) throws RapidSdkException;

    protected abstract V makeResult(Response var1) throws RapidSdkException;

    protected final WebResource getWebResource() {
        return this.webResource;
    }
}

