/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk.message.process.customer;

import com.eway.payment.rapid.sdk.beans.external.Customer;
import com.eway.payment.rapid.sdk.beans.external.TransactionType;
import com.eway.payment.rapid.sdk.beans.internal.Payment;
import com.eway.payment.rapid.sdk.entities.CreateAccessCodeSharedRequest;
import com.eway.payment.rapid.sdk.entities.CreateAccessCodeSharedResponse;
import com.eway.payment.rapid.sdk.entities.CreateCustomerResponse;
import com.eway.payment.rapid.sdk.entities.Request;
import com.eway.payment.rapid.sdk.entities.Response;
import com.eway.payment.rapid.sdk.exception.RapidSdkException;
import com.eway.payment.rapid.sdk.message.convert.CustomerToInternalCustomerConverter;
import com.eway.payment.rapid.sdk.message.convert.response.AccessCodeSharedToCreateCustConverter;
import com.eway.payment.rapid.sdk.message.process.AbstractMakeRequestMessageProcess;
import com.sun.jersey.api.client.WebResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustResponsiveUpdateMsgProcess
extends AbstractMakeRequestMessageProcess<Customer, CreateCustomerResponse> {
    public CustResponsiveUpdateMsgProcess(WebResource resource, String ... requestPath) {
        super(resource, requestPath);
    }

    @Override
    protected Request createRequest(Customer input) throws RapidSdkException {
        CreateAccessCodeSharedRequest request = new CreateAccessCodeSharedRequest();
        CustomerToInternalCustomerConverter interCustConvert = new CustomerToInternalCustomerConverter();
        Payment payment = new Payment();
        payment.setTotalAmount(0);
        request.setPayment(payment);
        request.setCustomer(interCustConvert.doConvert(input));
        request.setMethod("UpdateTokenCustomer");
        request.setTransactionType(TransactionType.Purchase.name());
        request.setRedirectUrl(input.getRedirectUrl());
        request.setCancelUrl(input.getCancelUrl());
        return request;
    }

    @Override
    protected CreateCustomerResponse makeResult(Response res) throws RapidSdkException {
        CreateAccessCodeSharedResponse response = (CreateAccessCodeSharedResponse)res;
        AccessCodeSharedToCreateCustConverter converter = new AccessCodeSharedToCreateCustConverter();
        return (CreateCustomerResponse)converter.doConvert(response);
    }

    @Override
    protected Response sendRequest(Request req) throws RapidSdkException {
        return this.doPost(req, CreateAccessCodeSharedResponse.class);
    }
}

