/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk.util;

import com.eway.payment.rapid.sdk.RapidClient;
import com.eway.payment.rapid.sdk.util.ResourceUtil;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RapidClientFilter
extends ClientFilter {
    private String apiVersion;
    private static final Logger LOGGER = LoggerFactory.getLogger(RapidClient.class);

    public void setVersion(String version) {
        this.apiVersion = version;
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        String userAgent = "";
        try {
            Properties prop = ResourceUtil.loadProperiesOnResourceFolder("rapid-api.properties");
            userAgent = prop.getProperty("rapid.sdk.user.agent");
            if (StringUtils.isBlank((CharSequence)userAgent)) {
                throw new Exception("Resource file rapid-api.properties is invalid.");
            }
        }
        catch (Exception e) {
            LOGGER.error("User Agent could not be loaded", (Throwable)e);
        }
        request.getHeaders().putSingle((Object)"User-Agent", (Object)userAgent);
        if (this.apiVersion != null) {
            request.getHeaders().putSingle((Object)"X-EWAY-APIVERSION", (Object)this.apiVersion);
        }
        return this.getNext().handle(request);
    }
}

