/*
 * Decompiled with CFR 0.152.
 */
package com.exsol.errorcodemodel;

import com.exasol.errorreporting.ExaError;
import com.exsol.errorcodemodel.ErrorIdentifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ErrorCodeParser {
    private static final Pattern ERROR_CODE_PATTERN = Pattern.compile("(?:([^-]+)-)?([A-Z][A-Z0-9]{0,9}(?:-[A-Z][A-Z0-9]{0,9})?)-(\\d+)");

    ErrorCodeParser() {
    }

    public ErrorIdentifier parse(String errorCodeString) throws ErrorIdentifier.SyntaxException {
        Matcher matcher = ERROR_CODE_PATTERN.matcher(errorCodeString);
        if (!matcher.matches()) {
            throw new ErrorIdentifier.SyntaxException(ExaError.messageBuilder((String)"E-ECMOJ-1").message("The error code {{error code}} has an invalid format.", new Object[0]).parameter("error code", (Object)errorCodeString).mitigation("Use a code like 'EXA-1', 'E-EXA-1' or 'W-EXA-MOD-2', tags can have max. 10 chars.", new Object[0]).toString());
        }
        ErrorIdentifier.Type errorType = this.parseErrorType(matcher.group(1), errorCodeString);
        String errorTag = matcher.group(2);
        int errorIndex = Integer.parseInt(matcher.group(3));
        return new ErrorIdentifier(errorType, errorTag, errorIndex);
    }

    private ErrorIdentifier.Type parseErrorType(String errorTypeString, String errorCode) throws ErrorIdentifier.SyntaxException {
        if (errorTypeString == null) {
            return ErrorIdentifier.Type.E;
        }
        try {
            return ErrorIdentifier.Type.valueOf(errorTypeString);
        }
        catch (IllegalArgumentException exception) {
            throw new ErrorIdentifier.SyntaxException(ExaError.messageBuilder((String)"E-ECMOJ-2").message("Illegal error code {{error code}}.", new Object[0]).mitigation("The codes must start with 'W-', 'E-' or 'F-'.", new Object[0]).parameter("error code", (Object)errorCode).toString());
        }
    }
}

