/*
 * Decompiled with CFR 0.152.
 */
package com.exsol.errorcodemodel;

import com.exsol.errorcodemodel.ErrorCodeParser;
import java.util.Objects;

public final class ErrorIdentifier {
    private final Type type;
    private final String tag;
    private final int index;

    public static ErrorIdentifier parse(String errorCode) throws SyntaxException {
        return new ErrorCodeParser().parse(errorCode);
    }

    public ErrorIdentifier(Type type, String tag, int index) {
        this.type = type;
        this.tag = tag;
        this.index = index;
    }

    public Type getType() {
        return this.type;
    }

    public String getTag() {
        return this.tag;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ErrorIdentifier that = (ErrorIdentifier)other;
        return this.index == that.index && this.type == that.type && Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.tag, this.index});
    }

    public String toString() {
        return this.type.toString() + "-" + this.tag + "-" + this.index;
    }

    public static class SyntaxException
    extends Exception {
        private static final long serialVersionUID = -4437252433544068436L;

        public SyntaxException(String message) {
            super(message);
        }

        public SyntaxException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static enum Type {
        E,
        F,
        W;

    }
}

