/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.datatype.type;

import com.exasol.datatype.type.DataType;
import com.exasol.sql.ColumnDefinitionVisitor;

public class IntervalDayToSecond
implements DataType {
    private static final String NAME = "INTERVAL DAY(%s) TO SECOND(%s)";
    private final int yearPrecision;
    private final int millisecondPrecision;

    public IntervalDayToSecond(int yearPrecision, int millisecondPrecision) {
        this.validateYearPrecision(yearPrecision);
        this.validateMillisecondPrecision(millisecondPrecision);
        this.yearPrecision = yearPrecision;
        this.millisecondPrecision = millisecondPrecision;
    }

    private void validateMillisecondPrecision(int millisecondPrecision) {
        if (millisecondPrecision < 0 || millisecondPrecision > 9) {
            throw new IllegalArgumentException("Millisecond precision must be a number between 0 and 9.");
        }
    }

    private void validateYearPrecision(int yearPrecision) {
        if (yearPrecision < 1 || yearPrecision > 9) {
            throw new IllegalArgumentException("Year precision must be a number between 1 and 9.");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public int getYearPrecision() {
        return this.yearPrecision;
    }

    public int getMillisecondPrecision() {
        return this.millisecondPrecision;
    }

    @Override
    public void accept(ColumnDefinitionVisitor visitor) {
        visitor.visit(this);
    }
}

