/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.datatype.value;

import com.exasol.datatype.value.AbstractInterval;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IntervalDayToSecond
extends AbstractInterval {
    private static final int SIGN_MATCHING_GROUP = 1;
    private static final int DAYS_MATCHING_GROUP = 2;
    private static final int HOURS_MATCHING_GROUP = 3;
    private static final int MINUTES_MATCHING_GROUP = 4;
    private static final int SECONDS_MATCHING_GROUP = 5;
    private static final int MILLIS_MATCHING_GROUP = 6;
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("([-+])?(?:(\\d{1,9})\\s+)?(\\d{1,2}):(\\d{1,2})(?::(\\d{1,2})(?:\\.(\\d{1,3}))?)?");

    private IntervalDayToSecond(long value) {
        super(value);
    }

    private IntervalDayToSecond(long absoluteValue, boolean positive) {
        super(absoluteValue, positive);
    }

    public String toString() {
        return String.format("%s%d %d:%02d:%02d.%03d", this.getSign(), this.getDays(), this.getHours(), this.getMinutes(), this.getSeconds(), this.getMillis());
    }

    private long getDays() {
        return this.value / 86400000L;
    }

    private long getHours() {
        return this.value / 3600000L % 24L;
    }

    private long getMinutes() {
        return this.value / 60000L % 60L;
    }

    private long getSeconds() {
        return this.value / 1000L % 60L;
    }

    private long getMillis() {
        return this.value % 1000L;
    }

    public long toMillis() {
        return this.getSignedValue();
    }

    public static IntervalDayToSecond ofMillis(long value) {
        return new IntervalDayToSecond(value);
    }

    public static IntervalDayToSecond parse(String text) {
        Matcher matcher = INTERVAL_PATTERN.matcher(text);
        if (matcher.matches()) {
            return IntervalDayToSecond.createIntervalFromParsingResults(matcher);
        }
        throw new IllegalArgumentException("Text \"" + text + "\" cannot be parsed to an INTERVAL. Must match \"" + INTERVAL_PATTERN + "\"");
    }

    private static IntervalDayToSecond createIntervalFromParsingResults(Matcher matcher) {
        long parsedValue = 86400000L * IntervalDayToSecond.parseMatchingGroupToLong(matcher, 2) + 3600000L * IntervalDayToSecond.parseMatchingGroupToLong(matcher, 3) + 60000L * IntervalDayToSecond.parseMatchingGroupToLong(matcher, 4) + 1000L * IntervalDayToSecond.parseMatchingGroupToLong(matcher, 5) + IntervalDayToSecond.parseMatchingGroupToLong(matcher, 6);
        boolean parsedPositive = !"-".equals(matcher.group(1));
        return new IntervalDayToSecond(parsedValue, parsedPositive);
    }
}

