/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.datatype.value;

import com.exasol.datatype.value.AbstractInterval;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IntervalYearToMonth
extends AbstractInterval {
    private static final int SIGN_MATCHING_GROUP = 1;
    private static final int YEARS_MATCHING_GROUP = 2;
    private static final int MONTHS_MATCHING_GROUP = 3;
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("([-+])?(\\d{1,9})-(\\d{1,2})");

    private IntervalYearToMonth(long value) {
        super(value);
    }

    private IntervalYearToMonth(long absoluteValue, boolean positive) {
        super(absoluteValue, positive);
    }

    public String toString() {
        return String.format("%s%d-%02d", this.getSign(), this.getYears(), this.getMonths());
    }

    private long getYears() {
        return this.value / 12L;
    }

    private long getMonths() {
        return this.value % 12L;
    }

    public long toMonths() {
        return this.getSignedValue();
    }

    public static IntervalYearToMonth ofMonths(long value) {
        return new IntervalYearToMonth(value);
    }

    public static IntervalYearToMonth parse(String text) {
        Matcher matcher = INTERVAL_PATTERN.matcher(text);
        if (matcher.matches()) {
            long parsedValue = 12L * IntervalYearToMonth.parseMatchingGroupToLong(matcher, 2) + IntervalYearToMonth.parseMatchingGroupToLong(matcher, 3);
            boolean parsedPositive = !"-".equals(matcher.group(1));
            return new IntervalYearToMonth(parsedValue, parsedPositive);
        }
        throw new IllegalArgumentException("Text \"" + text + "\" cannot be parsed to an INTERVAL. Must match \"" + INTERVAL_PATTERN + "\"");
    }
}

