/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql;

import com.exasol.sql.AbstractFragment;
import com.exasol.sql.Fragment;
import com.exasol.sql.UnnamedPlaceholder;
import com.exasol.sql.ValueTableVisitor;
import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.literal.BooleanLiteral;
import com.exasol.sql.expression.literal.DoubleLiteral;
import com.exasol.sql.expression.literal.FloatLiteral;
import com.exasol.sql.expression.literal.IntegerLiteral;
import com.exasol.sql.expression.literal.LongLiteral;
import com.exasol.sql.expression.literal.StringLiteral;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ValueTableRow
extends AbstractFragment {
    private final List<ValueExpression> expressions;

    public ValueTableRow(Fragment root, ValueExpression ... expressions) {
        super(root);
        this.expressions = Arrays.asList(expressions);
    }

    public ValueTableRow(Fragment root, String ... values) {
        super(root);
        this.expressions = new ArrayList<ValueExpression>(values.length);
        for (String value : values) {
            this.expressions.add(StringLiteral.of(value));
        }
    }

    private ValueTableRow(Builder builder) {
        super(builder.root);
        this.expressions = builder.expressions;
    }

    public List<ValueExpression> getExpressions() {
        return this.expressions;
    }

    public void accept(ValueTableVisitor visitor) {
        visitor.visit(this);
        visitor.leave(this);
    }

    public static Builder builder(Fragment root) {
        return new Builder(root);
    }

    public static class Builder {
        private final Fragment root;
        private final List<ValueExpression> expressions = new ArrayList<ValueExpression>();

        public Builder(Fragment root) {
            this.root = root;
        }

        public Builder add(String ... values) {
            for (String value : values) {
                this.expressions.add(StringLiteral.of(value));
            }
            return this;
        }

        public Builder add(char ... values) {
            for (char value : values) {
                this.expressions.add(StringLiteral.of(value));
            }
            return this;
        }

        public Builder add(int ... values) {
            for (int value : values) {
                this.expressions.add(IntegerLiteral.of(value));
            }
            return this;
        }

        public Builder add(long ... values) {
            for (long value : values) {
                this.expressions.add(LongLiteral.of(value));
            }
            return this;
        }

        public Builder add(double ... values) {
            for (double value : values) {
                this.expressions.add(DoubleLiteral.of(value));
            }
            return this;
        }

        public Builder add(float ... values) {
            for (float value : values) {
                this.expressions.add(FloatLiteral.of(value));
            }
            return this;
        }

        public Builder add(boolean ... values) {
            for (boolean value : values) {
                this.expressions.add(BooleanLiteral.of(value));
            }
            return this;
        }

        public Builder addPlaceholder() {
            this.expressions.add(new UnnamedPlaceholder());
            return this;
        }

        public Builder add(List<ValueExpression> expressions) {
            this.expressions.addAll(expressions);
            return this;
        }

        public ValueTableRow build() {
            return new ValueTableRow(this);
        }
    }
}

