/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.ddl.create;

import com.exasol.datatype.type.Boolean;
import com.exasol.datatype.type.Char;
import com.exasol.datatype.type.Date;
import com.exasol.datatype.type.Decimal;
import com.exasol.datatype.type.DoublePrecision;
import com.exasol.datatype.type.IntervalDayToSecond;
import com.exasol.datatype.type.IntervalYearToMonth;
import com.exasol.datatype.type.Timestamp;
import com.exasol.datatype.type.TimestampWithLocalTimezone;
import com.exasol.datatype.type.Varchar;
import com.exasol.sql.AbstractFragment;
import com.exasol.sql.ColumnsDefinition;
import com.exasol.sql.SqlStatement;
import com.exasol.sql.Table;
import com.exasol.sql.ddl.create.CreateTableFragment;
import com.exasol.sql.ddl.create.CreateTableVisitor;

public class CreateTable
extends AbstractFragment
implements SqlStatement,
CreateTableFragment {
    private final Table table;
    private final ColumnsDefinition columnsDefinition = new ColumnsDefinition(this);

    public CreateTable(String tableName) {
        super(null);
        this.table = new Table(this, tableName);
    }

    public synchronized CreateTable booleanColumn(String columnName) {
        this.columnsDefinition.add(columnName, new Boolean());
        return this;
    }

    public synchronized CreateTable charColumn(String columnName, int length) {
        this.columnsDefinition.add(columnName, new Char(length));
        return this;
    }

    public synchronized CreateTable varcharColumn(String columnName, int length) {
        this.columnsDefinition.add(columnName, new Varchar(length));
        return this;
    }

    public synchronized CreateTable dateColumn(String columnName) {
        this.columnsDefinition.add(columnName, new Date());
        return this;
    }

    public synchronized CreateTable decimalColumn(String columnName, int precision, int scale) {
        this.columnsDefinition.add(columnName, new Decimal(precision, scale));
        return this;
    }

    public synchronized CreateTable doublePrecisionColumn(String columnName) {
        this.columnsDefinition.add(columnName, new DoublePrecision());
        return this;
    }

    public synchronized CreateTable timestampColumn(String columnName) {
        this.columnsDefinition.add(columnName, new Timestamp());
        return this;
    }

    public synchronized CreateTable timestampWithLocalTimeZoneColumn(String columnName) {
        this.columnsDefinition.add(columnName, new TimestampWithLocalTimezone());
        return this;
    }

    public synchronized CreateTable intervalDayToSecondColumn(String columnName, int yearPrecision, int millisecondPrecision) {
        this.columnsDefinition.add(columnName, new IntervalDayToSecond(yearPrecision, millisecondPrecision));
        return this;
    }

    public synchronized CreateTable intervalYearToMonthColumn(String columnName, int yearPrecision) {
        this.columnsDefinition.add(columnName, new IntervalYearToMonth(yearPrecision));
        return this;
    }

    public String getTableName() {
        return this.table.getName();
    }

    public ColumnsDefinition getColumnsDefinition() {
        return this.columnsDefinition;
    }

    @Override
    public void accept(CreateTableVisitor visitor) {
        visitor.visit(this);
        this.table.accept(visitor);
        visitor.leave(this);
    }
}

