/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.expression;

import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.ValueExpressionVisitor;

public class BinaryArithmeticExpression
implements ValueExpression {
    private final BinaryArithmeticOperator arithmeticOperator;
    private final ValueExpression left;
    private final ValueExpression right;

    private BinaryArithmeticExpression(BinaryArithmeticOperator arithmeticOperator, ValueExpression left, ValueExpression right) {
        this.arithmeticOperator = arithmeticOperator;
        this.left = left;
        this.right = right;
    }

    public static BinaryArithmeticExpression of(BinaryArithmeticOperator operator, ValueExpression left, ValueExpression right) {
        return new BinaryArithmeticExpression(operator, left, right);
    }

    public String getStringOperatorRepresentation() {
        return this.arithmeticOperator.getStringOperatorRepresentation();
    }

    @Override
    public void accept(ValueExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public ValueExpression getLeft() {
        return this.left;
    }

    public ValueExpression getRight() {
        return this.right;
    }

    public static enum BinaryArithmeticOperator {
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("*"),
        DIVIDE("/");

        private final String stringOperatorRepresentation;

        private BinaryArithmeticOperator(String stringOperatorRepresentation) {
            this.stringOperatorRepresentation = stringOperatorRepresentation;
        }

        private String getStringOperatorRepresentation() {
            return this.stringOperatorRepresentation;
        }
    }
}

