/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.expression.comparison;

import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.comparison.AbstractComparison;
import com.exasol.sql.expression.comparison.ComparisonOperator;
import com.exasol.sql.expression.comparison.ComparisonVisitor;

public class LikeComparison
extends AbstractComparison {
    private final Character escape;

    private LikeComparison(Builder builder) {
        super(builder.operator, builder.left, builder.right);
        this.escape = builder.escape;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void accept(ComparisonVisitor visitor) {
        visitor.visit(this);
    }

    public boolean hasNot() {
        return this.getOperator().equals(LikeComparisonOperator.NOT_LIKE);
    }

    public boolean hasEscape() {
        return this.escape != null;
    }

    public Character getEscape() {
        return this.escape;
    }

    public static class Builder {
        private ValueExpression left;
        private ValueExpression right;
        private LikeComparisonOperator operator = LikeComparisonOperator.LIKE;
        private Character escape = null;

        public Builder left(ValueExpression left) {
            this.left = left;
            return this;
        }

        public Builder right(ValueExpression right) {
            this.right = right;
            return this;
        }

        public Builder not() {
            this.operator = LikeComparisonOperator.NOT_LIKE;
            return this;
        }

        public Builder escape(char escape) {
            this.escape = Character.valueOf(escape);
            return this;
        }

        public LikeComparison build() {
            return new LikeComparison(this);
        }
    }

    public static enum LikeComparisonOperator implements ComparisonOperator
    {
        LIKE,
        NOT_LIKE;


        @Override
        public String toString() {
            return super.toString().replace("_", " ");
        }
    }
}

