/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.expression.comparison;

import com.exasol.sql.expression.comparison.ComparisonOperator;

public enum SimpleComparisonOperator implements ComparisonOperator
{
    EQUAL("="),
    NOT_EQUAL("<>"),
    GREATER_THAN(">"),
    GREATER_THAN_OR_EQUAL(">="),
    LESS_THAN("<"),
    LESS_THAN_OR_EQUAL("<=");

    private final String operatorSymbol;

    private SimpleComparisonOperator(String operatorSymbol) {
        this.operatorSymbol = operatorSymbol;
    }

    @Override
    public String toString() {
        return this.operatorSymbol;
    }

    public static SimpleComparisonOperator ofSymbol(String operatorSymbol) {
        for (SimpleComparisonOperator operator : SimpleComparisonOperator.values()) {
            if (!operator.operatorSymbol.equals(operatorSymbol)) continue;
            return operator;
        }
        throw new IllegalArgumentException("Unknown comparison operator \"" + operatorSymbol + "\"");
    }
}

