/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.rendering;

public final class StringRendererConfig {
    private final boolean lowerCase;
    private final boolean quote;

    private StringRendererConfig(Builder builder) {
        this.lowerCase = builder.lowerCase;
        this.quote = builder.quote;
    }

    public boolean useLowerCase() {
        return this.lowerCase;
    }

    public boolean useQuotes() {
        return this.quote;
    }

    public static StringRendererConfig createDefault() {
        return StringRendererConfig.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean lowerCase = false;
        private boolean quote = false;

        private Builder() {
        }

        public StringRendererConfig build() {
            return new StringRendererConfig(this);
        }

        public Builder lowerCase(boolean lowerCase) {
            this.lowerCase = lowerCase;
            return this;
        }

        public Builder quoteIdentifiers(boolean quote) {
            this.quote = quote;
            return this;
        }
    }
}

