/*
 * Decompiled with CFR 0.152.
 */
package com.excelbdd;

import com.excelbdd.Behavior;
import com.excelbdd.ExcelBDDSource;
import com.excelbdd.TestWizard;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

public class ExcelBDDArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<ExcelBDDSource> {
    private String file;
    private String sheet;
    private String brotherFolder;
    private String headerMatcher;
    private String headerUnmatcher;

    public void accept(ExcelBDDSource source) {
        this.file = source.file();
        this.sheet = source.sheet();
        this.brotherFolder = source.brotherFolder();
        this.headerMatcher = source.headerMatcher();
        this.headerUnmatcher = source.headerUnmatcher();
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        List<Map<String, String>> list;
        String filePath;
        if (this.brotherFolder.isEmpty()) {
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                File theFile = new File(classLoader.getResource(this.file).getFile());
                filePath = theFile.getAbsolutePath();
                list = Behavior.getExampleList(filePath, this.sheet, this.headerMatcher, this.headerUnmatcher);
            }
            catch (FileNotFoundException e) {
                filePath = this.file;
                list = Behavior.getExampleList(this.file, this.sheet, this.headerMatcher, this.headerUnmatcher);
            }
        } else {
            filePath = TestWizard.getExcelBDDStartPath(this.brotherFolder) + this.file;
            list = Behavior.getExampleList(filePath, this.sheet, this.headerMatcher, this.headerUnmatcher);
        }
        System.out.println(filePath);
        ArrayList<Arguments> listb = new ArrayList<Arguments>();
        for (Map<String, String> map : list) {
            listb.add(Arguments.of((Object[])new Object[]{map}));
        }
        return listb.stream();
    }
}

