/*
 * Decompiled with CFR 0.152.
 */
package com.excelbdd;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TestWizard {
    public static final String ANY_MATCHER = ".*";
    public static final String NEVER_MATCHED_STRING = "i_m_p_o_s_i_b_l_e_matcher";
    private Map<String, String> map;

    public TestWizard(Map<String, String> parameterMap) {
        if (parameterMap != null) {
            this.map = parameterMap;
            TestWizard.showMap(parameterMap);
        }
    }

    public static String getExcelBDDStartPath(String childPath) throws Exception {
        String absolutePath = new File(".").getAbsolutePath();
        if (absolutePath.lastIndexOf(childPath) >= 0) {
            return absolutePath.substring(0, absolutePath.lastIndexOf(childPath));
        }
        throw new IOException(childPath + " is not in " + absolutePath);
    }

    public static void showMap(Map<String, String> parameterMap) {
        if (parameterMap.get("Header") != null) {
            System.out.println(String.format("=======Header: %s=======", parameterMap.get("Header")));
        } else {
            System.out.println("================");
        }
        for (Map.Entry<String, String> param : parameterMap.entrySet()) {
            System.out.println(String.format("%s --- %s", param.getKey(), param.getValue()));
        }
        System.out.println("========End of Map========");
    }

    public static String makeMatcherString(String matcher) {
        return ANY_MATCHER + matcher + ANY_MATCHER;
    }

    public static Collection<Object[]> getExampleCollection(List<Map<String, String>> listTestData) {
        ArrayList<Object[]> collectionTestData = new ArrayList<Object[]>();
        for (Map<String, String> map : listTestData) {
            Object[] arrayObj = new Object[]{map};
            collectionTestData.add(arrayObj);
        }
        return collectionTestData;
    }

    public String get(String string) {
        return this.map.get(string);
    }

    public String getString(String string) {
        String originValue = this.get(string);
        if (originValue.endsWith(".0")) {
            try {
                return String.valueOf(Double.valueOf(originValue).intValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return originValue;
    }

    public int getInt(String string) {
        int value;
        try {
            value = Double.valueOf(string).intValue();
        }
        catch (NumberFormatException e) {
            value = Double.valueOf(this.map.get(string)).intValue();
        }
        return value;
    }

    public long getLong(String string) {
        long value;
        try {
            value = Double.valueOf(string).longValue();
        }
        catch (NumberFormatException e) {
            value = Double.valueOf(this.map.get(string)).longValue();
        }
        return value;
    }

    public double getDouble(String string) {
        double value;
        try {
            value = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            value = Double.parseDouble(this.map.get(string));
        }
        return value;
    }

    public float getFloat(String string) {
        float value;
        try {
            value = Float.parseFloat(string);
        }
        catch (NumberFormatException e) {
            value = Float.parseFloat(this.map.get(string));
        }
        return value;
    }

    public boolean getBoolean(String string) {
        String value = this.map.get(string);
        if (value == null) {
            return false;
        }
        String uValue = value.toUpperCase();
        return "TRUE".equals(uValue) || "YES".equals(uValue) || "Y".equals(uValue);
    }

    public char getChar(String string) {
        String value = this.map.get(string);
        return value.charAt(0);
    }

    public byte getByte(String string) {
        return Double.valueOf(this.map.get(string)).byteValue();
    }

    public short getShort(String string) {
        return Double.valueOf(this.map.get(string)).shortValue();
    }

    public static String getTestResourcesPath(String file) throws Exception {
        TestWizard w = new TestWizard(null);
        return w.findTestResourcesPath(file);
    }

    protected String findTestResourcesPath(String file) throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL url = classLoader.getResource(file);
        if (url != null) {
            return url.getFile();
        }
        throw new Exception("No such file:" + file);
    }
}

