/*
 * Decompiled with CFR 0.152.
 */
package com.excelbdd;

import com.excelbdd.TestWizard;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Behavior {
    private static final char DEFAULT_START_COLUMN_PLACEHOLDER = '`';
    private static final String SIMPLE = "SIMPLE";
    private static final String TESTRESULT = "TESTRESULT";
    private static final String EXPECTED = "EXPECTED";

    private Behavior() {
    }

    public static List<Map<String, String>> getExampleList(String excelPath) throws Exception {
        return Behavior.getExampleList(excelPath, "", ".*");
    }

    public static List<Map<String, String>> getExampleList(String excelPath, String worksheetName) throws Exception {
        return Behavior.getExampleList(excelPath, worksheetName, ".*");
    }

    public static List<Map<String, String>> getExampleList(String excelPath, String worksheetName, String headerMatcher) throws Exception {
        return Behavior.getExampleList(excelPath, worksheetName, headerMatcher, "i_m_p_o_s_i_b_l_e_matcher");
    }

    private static boolean hasInputGrid(XSSFRow rowCurrent, int iCol) {
        try {
            return rowCurrent.getCell(iCol + 1).getStringCellValue().equals("Input");
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private static boolean hasTestResultGrid(XSSFRow rowCurrent, int iCol) {
        try {
            return rowCurrent.getCell(iCol + 3).getStringCellValue().equals("Test Result");
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private static XSSFSheet getExampleSheet(String worksheetName, FileInputStream excelFile, XSSFWorkbook workbook) throws Exception {
        XSSFSheet sheetTestData = worksheetName.isEmpty() ? workbook.getSheetAt(0) : workbook.getSheet(worksheetName);
        if (sheetTestData == null) {
            workbook.close();
            excelFile.close();
            throw new IOException(worksheetName + " sheet does not exist.");
        }
        return sheetTestData;
    }

    private static boolean isParameterNameGrid(String cellValue) {
        return cellValue.matches("Param.*Name.*");
    }

    private static HashMap<Integer, Integer> getHeaderMap(String headerMatcher, String headerUnmatcher, ArrayList<Map<String, String>> listTestSet, int parameterNameColumnNum, XSSFRow rowHeader, int step) {
        XSSFCell cellHeader;
        String strRealHeaderMatcher = TestWizard.makeMatcherString(headerMatcher);
        String strRealHeaderUnmatcher = headerUnmatcher.isEmpty() || headerUnmatcher.equals("i_m_p_o_s_i_b_l_e_matcher") ? "i_m_p_o_s_i_b_l_e_matcher" : TestWizard.makeMatcherString(headerUnmatcher);
        short nMaxColumn = rowHeader.getLastCellNum();
        HashMap<Integer, Integer> mapTestSetHeader = new HashMap<Integer, Integer>();
        int nTestSet = 0;
        for (int iCol = parameterNameColumnNum + 1; iCol < nMaxColumn && (cellHeader = rowHeader.getCell(iCol)) != null; iCol += step) {
            String strHeader = cellHeader.getStringCellValue();
            if (!Behavior.isHeaderValid(strRealHeaderMatcher, strRealHeaderUnmatcher, strHeader)) continue;
            mapTestSetHeader.put(iCol, nTestSet);
            HashMap<String, String> mapTestSet = new HashMap<String, String>();
            mapTestSet.put("Header", cellHeader.getStringCellValue());
            listTestSet.add(mapTestSet);
            ++nTestSet;
        }
        return mapTestSetHeader;
    }

    private static boolean isHeaderValid(String strRealHeaderMatcher, String strRealHeaderUnmatcher, String strHeader) {
        return strHeader != null && !strHeader.isEmpty() && strHeader.matches(strRealHeaderMatcher) && !strHeader.matches(strRealHeaderUnmatcher);
    }

    private static HashMap<Integer, String> getParameterNameMap(int parameterStartRow, int parameterNameColumnNum, XSSFSheet sheetTestData) {
        HashMap<Integer, String> mapParameterName = new HashMap<Integer, String>();
        int nContinuousBlankCount = 0;
        for (int iRow = parameterStartRow; iRow <= sheetTestData.getLastRowNum() && nContinuousBlankCount <= 10; ++iRow) {
            XSSFRow rowCurrent = sheetTestData.getRow(iRow);
            if (rowCurrent == null) {
                ++nContinuousBlankCount;
                continue;
            }
            XSSFCell cellParameterName = rowCurrent.getCell(parameterNameColumnNum);
            if (cellParameterName == null) {
                ++nContinuousBlankCount;
                continue;
            }
            String strParameterName = cellParameterName.getStringCellValue();
            if (strParameterName == null || strParameterName.isEmpty()) {
                ++nContinuousBlankCount;
                continue;
            }
            if (strParameterName.equals("NA")) {
                nContinuousBlankCount = 0;
                continue;
            }
            mapParameterName.put(iRow, strParameterName);
            nContinuousBlankCount = 0;
        }
        return mapParameterName;
    }

    public static List<Map<String, String>> getExampleList(String excelPath, String worksheetName, String headerMatcher, String headerUnmatcher) throws Exception {
        File fileExcel = Behavior.getExcelFile(excelPath);
        FileInputStream excelFile = new FileInputStream(fileExcel);
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)excelFile);
        XSSFSheet sheetTestData = Behavior.getExampleSheet(worksheetName, excelFile, workbook);
        int headerRow = 0;
        char parameterNameColumn = '\u0000';
        String columnType = null;
        for (int iRow = 0; iRow < sheetTestData.getLastRowNum(); ++iRow) {
            XSSFRow rowCurrent = sheetTestData.getRow(iRow);
            if (rowCurrent == null) continue;
            for (int iCol = 0; iCol < rowCurrent.getLastCellNum(); ++iCol) {
                String cellValue;
                XSSFCell cellCurrent = rowCurrent.getCell(iCol);
                if (cellCurrent == null || !cellCurrent.getCellType().equals((Object)CellType.STRING) || !Behavior.isParameterNameGrid(cellValue = cellCurrent.getStringCellValue())) continue;
                parameterNameColumn = (char)(iCol + 65);
                if (Behavior.hasInputGrid(rowCurrent, iCol)) {
                    headerRow = iRow;
                    if (Behavior.hasTestResultGrid(rowCurrent, iCol)) {
                        columnType = TESTRESULT;
                        break;
                    }
                    columnType = EXPECTED;
                    break;
                }
                columnType = SIMPLE;
                headerRow = iRow + 1;
                break;
            }
            if (columnType != null) break;
        }
        if (columnType == null) {
            throw new IOException("Parameter Name grid is not found.");
        }
        return Behavior.getExampleListFromWorksheet(excelFile, sheetTestData, headerRow, parameterNameColumn, headerMatcher, headerUnmatcher, columnType);
    }

    private static List<Map<String, String>> getExampleListFromWorksheet(FileInputStream excelFile, XSSFSheet sheetTestData, int headerRow, char parameterNameColumn, String headerMatcher, String headerUnmatcher, String columnType) throws Exception {
        int actualHeaderRow = headerRow - 1;
        int actualParameterStartRow = headerRow;
        int columnStep = 1;
        if (TESTRESULT.equals(columnType)) {
            actualParameterStartRow = headerRow + 1;
            columnStep = 3;
        } else if (EXPECTED.equals(columnType)) {
            actualParameterStartRow = headerRow + 1;
            columnStep = 2;
        }
        ArrayList<Map<String, String>> listTestSet = new ArrayList<Map<String, String>>();
        int parameterNameColumnNum = parameterNameColumn - 65;
        XSSFRow rowHeader = sheetTestData.getRow(actualHeaderRow);
        HashMap<Integer, Integer> mapTestSetHeader = Behavior.getHeaderMap(headerMatcher, headerUnmatcher, listTestSet, parameterNameColumnNum, rowHeader, columnStep);
        HashMap<Integer, String> mapParameterName = Behavior.getParameterNameMap(actualParameterStartRow, parameterNameColumnNum, sheetTestData);
        for (Map.Entry<Integer, String> aParameterName : mapParameterName.entrySet()) {
            int iRow = aParameterName.getKey();
            String strParameterName = aParameterName.getValue();
            XSSFRow rowCurrent = sheetTestData.getRow(iRow);
            for (Map.Entry<Integer, Integer> entryHeader : mapTestSetHeader.entrySet()) {
                int iCol = entryHeader.getKey();
                Map<String, String> mapTestSet = listTestSet.get(entryHeader.getValue());
                Behavior.putParameter(strParameterName, rowCurrent, mapTestSet, iCol);
                if (columnStep <= 1) continue;
                Behavior.putParameter(strParameterName + "Expected", rowCurrent, mapTestSet, iCol + 1);
                if (columnStep != 3) continue;
                Behavior.putParameter(strParameterName + "TestResult", rowCurrent, mapTestSet, iCol + 2);
            }
        }
        sheetTestData.getWorkbook().close();
        excelFile.close();
        return listTestSet;
    }

    private static void putParameter(String strParameterName, XSSFRow rowCurrent, Map<String, String> mapTestSet, int iCol) {
        XSSFCell cellCurrent = rowCurrent.getCell(iCol);
        if (cellCurrent == null) {
            mapTestSet.put(strParameterName, "");
        } else if (cellCurrent.getCellType().equals((Object)CellType.STRING)) {
            mapTestSet.put(strParameterName, cellCurrent.getStringCellValue());
        } else if (cellCurrent.getCellType().equals((Object)CellType.BLANK)) {
            mapTestSet.put(strParameterName, "");
        } else if (cellCurrent.getCellType().equals((Object)CellType.NUMERIC)) {
            mapTestSet.put(strParameterName, String.valueOf(cellCurrent.getNumericCellValue()));
        } else if (cellCurrent.getCellType().equals((Object)CellType.BOOLEAN)) {
            mapTestSet.put(strParameterName, String.valueOf(cellCurrent.getBooleanCellValue()));
        } else {
            mapTestSet.put(strParameterName, cellCurrent.getRawValue());
        }
    }

    public static List<Map<String, String>> getExampleTable(String excelPath, String worksheetName) throws Exception {
        return Behavior.getExampleTable(excelPath, worksheetName, 1, '`');
    }

    public static List<Map<String, String>> getExampleTable(String excelPath, String worksheetName, int headerRow) throws Exception {
        return Behavior.getExampleTable(excelPath, worksheetName, headerRow, '`');
    }

    public static List<Map<String, String>> getExampleTable(String excelPath, String worksheetName, int headerRow, char startColumn) throws Exception {
        File fileExcel = Behavior.getExcelFile(excelPath);
        int startColumnNum = startColumn - 65;
        if (startColumn != '`' && (startColumnNum < 0 || startColumnNum > 25)) {
            throw new Exception("Start Column must in A~Z, but it is " + startColumn);
        }
        ArrayList<Map<String, String>> listTestSet = new ArrayList<Map<String, String>>();
        try (FileInputStream excelFile = new FileInputStream(fileExcel);
             XSSFWorkbook workbook = new XSSFWorkbook((InputStream)excelFile);){
            XSSFCell firstCell;
            XSSFRow rowCurrent;
            XSSFSheet sheetTestData = Behavior.getExampleSheet(worksheetName, excelFile, workbook);
            int actualHeaderRow = headerRow - 1;
            XSSFRow rowHeader = sheetTestData.getRow(actualHeaderRow);
            int nMaxColumn = rowHeader.getLastCellNum();
            int nMaxRow = sheetTestData.getLastRowNum();
            if (startColumn == '`') {
                for (int iCol = 0; iCol <= nMaxColumn; ++iCol) {
                    XSSFCell cellHeader = rowHeader.getCell(iCol);
                    if (cellHeader == null) continue;
                    startColumnNum = iCol;
                    break;
                }
            }
            for (int iRow = headerRow; iRow <= nMaxRow && (rowCurrent = sheetTestData.getRow(iRow)) != null && (firstCell = rowCurrent.getCell(startColumnNum)) != null && !firstCell.getCellType().equals((Object)CellType.BLANK); ++iRow) {
                HashMap<String, String> mapTestSet = new HashMap<String, String>();
                for (int iCol = startColumnNum; iCol <= nMaxColumn; ++iCol) {
                    XSSFCell cellHeader = rowHeader.getCell(iCol);
                    if (cellHeader == null) continue;
                    Behavior.putParameter(cellHeader.getStringCellValue(), rowCurrent, mapTestSet, iCol);
                }
                listTestSet.add(mapTestSet);
            }
            workbook.close();
            excelFile.close();
        }
        return listTestSet;
    }

    private static File getExcelFile(String excelPath) throws Exception {
        File fileExcel;
        try {
            String fullFilePath = TestWizard.getTestResourcesPath(excelPath);
            fileExcel = new File(fullFilePath);
        }
        catch (Exception e) {
            fileExcel = new File(excelPath);
        }
        if (!fileExcel.isFile()) {
            throw new FileNotFoundException("No such file:" + excelPath);
        }
        return fileExcel;
    }
}

