/*
 * Decompiled with CFR 0.152.
 */
package com.excelbdd;

import com.excelbdd.Behavior;
import com.excelbdd.ExcelBDDSource;
import com.excelbdd.TestWizard;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

public class ExcelBDDArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<ExcelBDDSource> {
    private String file;
    private String sheet;
    private String brotherFolder;
    private String headerMatcher;
    private String headerUnmatcher;

    public void accept(ExcelBDDSource source) {
        this.file = source.file();
        this.sheet = source.sheet();
        this.brotherFolder = source.brotherFolder();
        this.headerMatcher = source.headerMatcher();
        this.headerUnmatcher = source.headerUnmatcher();
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        List<Map<String, String>> list;
        if (this.brotherFolder.isEmpty()) {
            list = Behavior.getExampleList(this.file, this.sheet, this.headerMatcher, this.headerUnmatcher);
        } else {
            String filePath = TestWizard.getExcelBDDStartPath(this.brotherFolder) + this.file;
            list = Behavior.getExampleList(filePath, this.sheet, this.headerMatcher, this.headerUnmatcher);
        }
        ArrayList<Arguments> listb = new ArrayList<Arguments>();
        for (Map<String, String> map : list) {
            listb.add(Arguments.of((Object[])new Object[]{map}));
        }
        return listb.stream();
    }
}

