/*
 * Decompiled with CFR 0.152.
 */
package com.excelbdd;

import com.excelbdd.Behavior;
import com.excelbdd.ExcelFileSource;
import com.excelbdd.TestWizard;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

public class ExcelFileArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<ExcelFileSource> {
    private String file;
    private String sheet;
    private String brotherFolder;
    private int headerRow;
    private char startColumn;

    public void accept(ExcelFileSource source) {
        this.file = source.file();
        this.sheet = source.sheet();
        this.brotherFolder = source.brotherFolder();
        this.headerRow = source.headerRow();
        this.startColumn = source.startColumn();
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        List<Map<String, String>> list;
        if (this.brotherFolder.isEmpty()) {
            list = Behavior.getExampleTable(this.file, this.sheet, this.headerRow, this.startColumn);
        } else {
            String filePath = TestWizard.getExcelBDDStartPath(this.brotherFolder) + this.file;
            list = Behavior.getExampleTable(filePath, this.sheet, this.headerRow, this.startColumn);
        }
        ArrayList<Arguments> listb = new ArrayList<Arguments>();
        for (Map<String, String> map : list) {
            listb.add(Arguments.of((Object[])new Object[]{map}));
        }
        return listb.stream();
    }
}

