/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk.api.user;

import com.fangcloud.sdk.YfyClient;
import com.fangcloud.sdk.YfyRequestUtil;
import com.fangcloud.sdk.api.user.SearchUserResult;
import com.fangcloud.sdk.api.user.UpdateSelfArg;
import com.fangcloud.sdk.api.user.YfyUser;
import com.fangcloud.sdk.exception.NetworkIOException;
import com.fangcloud.sdk.exception.YfyException;
import com.fangcloud.sdk.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class YfyUserRequest {
    private static final String USER_PATH = "api/v2/user/";
    private static final String SELF_INFO_PATH = "api/v2/user/info";
    private static final String USER_INFO_PATH = "api/v2/user/%s/info";
    private static final String PROFILE_PIC_DOWNLOAD_PATH = "api/v2/user/%s/profile_pic_download";
    private static final String UPDATE_USER_PATH = "api/v2/user/update";
    private static final String SEARCH_USER_PATH = "api/v2/user/search";
    private final YfyClient.YfyInternalClient client;

    public YfyUserRequest(YfyClient.YfyInternalClient client) {
        this.client = client;
    }

    public YfyUser getSelf() throws YfyException {
        return this.client.doGet(SELF_INFO_PATH, null, null, YfyUser.class);
    }

    public YfyUser getUser(long userId) throws YfyException {
        String[] param = new String[]{String.valueOf(userId)};
        return this.getUser(param);
    }

    private YfyUser getUser(String[] param) throws YfyException {
        return this.client.doGet(USER_INFO_PATH, param, null, YfyUser.class);
    }

    public void downloadProfilePic(long userId, final String profilePicKey, String savePath) throws YfyException {
        Object[] params = new Object[]{String.valueOf(userId)};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("profile_pic_key", profilePicKey);
            }
        };
        String downloadUrl = YfyRequestUtil.buildUrlWithParams(this.client.getHost().getApi(), String.format(PROFILE_PIC_DOWNLOAD_PATH, params), (Map<String, String>)mapParams);
        InputStream body = this.client.doDownload(downloadUrl, true, null);
        File file = new File(savePath);
        try {
            IOUtil.copyStreamToFile(body, file);
        }
        catch (IOException ex) {
            throw new NetworkIOException(ex);
        }
        finally {
            IOUtil.closeQuietly(body);
        }
    }

    public YfyUser updateSelf(String name) throws YfyException {
        return this.updateSelf(new UpdateSelfArg(name));
    }

    private YfyUser updateSelf(UpdateSelfArg updateSelfArg) throws YfyException {
        return this.client.doPost(UPDATE_USER_PATH, null, updateSelfArg, YfyUser.class);
    }

    public SearchUserResult searchUser(final String queryWords, final int pageId) throws YfyException {
        HashMap<String, String> params = new HashMap<String, String>(){
            {
                this.put("query_words", queryWords);
                this.put("page_id", String.valueOf(pageId));
            }
        };
        return this.searchUser((Map<String, String>)params);
    }

    private SearchUserResult searchUser(Map<String, String> params) throws YfyException {
        return this.client.doGet(SEARCH_USER_PATH, null, params, SearchUserResult.class);
    }
}

