/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk;

import com.fangcloud.sdk.YfyProgressListener;
import com.fangcloud.sdk.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends InputStream {
    private final InputStream inputStream;
    private final YfyProgressListener progressListener;
    private long total;
    private long totalRead;
    private long lastRead;
    private long speed;
    private long timestamp;

    public ProgressInputStream(InputStream inputStream, YfyProgressListener progressListener, long total) {
        this.inputStream = inputStream;
        this.progressListener = progressListener;
        this.total = total;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public int read() throws IOException {
        int read = this.inputStream.read();
        ++this.totalRead;
        this.calculateProgress();
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.inputStream.read(b, off, len);
        this.totalRead += (long)read;
        this.calculateProgress();
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.inputStream.read(b);
        this.totalRead += (long)read;
        this.calculateProgress();
        return read;
    }

    private void calculateProgress() {
        long now = System.currentTimeMillis();
        if (now - this.timestamp > 1000L) {
            this.speed = (this.totalRead - this.lastRead) * 1000L / (now - this.timestamp);
            this.lastRead = this.totalRead;
            this.timestamp = now;
            this.progressListener.onProgressChanged(this.totalRead, this.total, StringUtil.formatBytes(this.speed) + "/s");
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

