/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk.api.admin.platform;

import com.fangcloud.sdk.YfyBaseClient;
import com.fangcloud.sdk.api.admin.platform.YfyMappingDepartment;
import com.fangcloud.sdk.api.admin.platform.YfyMappingGroup;
import com.fangcloud.sdk.api.admin.platform.YfyMappingUser;
import com.fangcloud.sdk.api.admin.user.YfyDetailedUser;
import com.fangcloud.sdk.exception.YfyException;
import java.util.HashMap;
import java.util.Map;

public class YfyAdminPlatformRequest {
    private static final String ADMIN_PLATFORM_PATH = "api/v2/admin/platform/";
    private static final String MAPPING_USER_PATH = "api/v2/admin/platform/%s/mapping_user";
    private static final String MAPPING_DEPARTMENT_PATH = "api/v2/admin/platform/%s/mapping_department";
    private static final String MAPPING_GROUP_PATH = "api/v2/admin/platform/%s/mapping_group";
    private final YfyBaseClient.YfyInternalClient client;

    public YfyAdminPlatformRequest(YfyBaseClient.YfyInternalClient client) {
        this.client = client;
    }

    public YfyDetailedUser getMappingUser(long platformId, final String userId) throws YfyException {
        String[] listParams = new String[]{String.valueOf(platformId)};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("user_id", userId);
            }
        };
        return this.getMappingUser(listParams, (Map<String, String>)mapParams);
    }

    public YfyDetailedUser getMappingUser(long platformId, final long yfyUserId) throws YfyException {
        String[] listParams = new String[]{String.valueOf(platformId)};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("yfy_user_id", String.valueOf(yfyUserId));
            }
        };
        return this.getMappingUser(listParams, (Map<String, String>)mapParams);
    }

    public YfyMappingDepartment getMappingDepartment(long platformId, final String departmentId) throws YfyException {
        String[] listParams = new String[]{String.valueOf(platformId)};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("department_id", departmentId);
            }
        };
        return this.getMappingDepartment(listParams, (Map<String, String>)mapParams);
    }

    public YfyMappingDepartment getMappingDepartment(long platformId, final long yfyDepartmentId) throws YfyException {
        String[] listParams = new String[]{String.valueOf(platformId)};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("yfy_department_id", String.valueOf(yfyDepartmentId));
            }
        };
        return this.getMappingDepartment(listParams, (Map<String, String>)mapParams);
    }

    public YfyMappingGroup getMappingGroup(long platformId, final String groupId) throws YfyException {
        String[] listParams = new String[]{String.valueOf(platformId)};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("group_id", groupId);
            }
        };
        return this.getMappingGroup(listParams, (Map<String, String>)mapParams);
    }

    public YfyMappingGroup getMappingGroup(long platformId, final long yfyGroupId) throws YfyException {
        String[] listParams = new String[]{String.valueOf(platformId)};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("yfy_group_id", String.valueOf(yfyGroupId));
            }
        };
        return this.getMappingGroup(listParams, (Map<String, String>)mapParams);
    }

    private YfyMappingUser getMappingUser(String[] listParams, Map<String, String> mapParams) throws YfyException {
        return this.client.doGet(MAPPING_USER_PATH, listParams, mapParams, YfyMappingUser.class);
    }

    private YfyMappingDepartment getMappingDepartment(String[] listParams, Map<String, String> mapParams) throws YfyException {
        return this.client.doGet(MAPPING_DEPARTMENT_PATH, listParams, mapParams, YfyMappingDepartment.class);
    }

    private YfyMappingGroup getMappingGroup(String[] listParams, Map<String, String> mapParams) throws YfyException {
        return this.client.doGet(MAPPING_GROUP_PATH, listParams, mapParams, YfyMappingGroup.class);
    }
}

