/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server;

import com.featureprobe.sdk.server.AccessEvent;
import com.featureprobe.sdk.server.Event;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccessRecorder {
    Map<String, List<Counter>> counters;
    long startTime;
    long endTime;

    AccessRecorder() {
        this.counters = new HashMap<String, List<Counter>>();
    }

    private AccessRecorder(AccessRecorder accessRecorder) {
        this.counters = new HashMap<String, List<Counter>>(accessRecorder.counters);
        this.startTime = accessRecorder.startTime;
        this.endTime = System.currentTimeMillis();
    }

    public void add(Event event) {
        AccessEvent accessEvent = (AccessEvent)event;
        if (this.counters.isEmpty()) {
            this.startTime = System.currentTimeMillis();
        }
        if (this.counters.containsKey(accessEvent.getKey())) {
            List<Counter> counters = this.counters.get(accessEvent.getKey());
            for (Counter counter : counters) {
                if (!counter.isGroup(accessEvent.getValue(), accessEvent.getVersion(), accessEvent.getIndex())) continue;
                counter.increment();
                return;
            }
            counters.add(new Counter(accessEvent.getValue(), accessEvent.getVersion(), accessEvent.getIndex()));
        } else {
            ArrayList<Counter> groups = new ArrayList<Counter>(1);
            groups.add(new Counter(accessEvent.getValue(), accessEvent.getVersion(), accessEvent.getIndex()));
            this.counters.put(accessEvent.getKey(), groups);
        }
    }

    public void clear() {
        this.counters = new HashMap<String, List<Counter>>();
    }

    public AccessRecorder snapshot() {
        return new AccessRecorder(this);
    }

    public Map<String, List<Counter>> getCounters() {
        return this.counters;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    static final class Counter {
        long count;
        final String value;
        final Long version;
        final Integer index;

        public Counter(String value, Long version, Integer index) {
            this.value = value;
            this.version = version;
            this.index = index;
            this.count = 1L;
        }

        public void increment() {
            ++this.count;
        }

        public boolean isGroup(String value, Long version, Integer index) {
            return this.value.equals(value) && this.version.equals(version) && this.index.equals(index);
        }

        public long getCount() {
            return this.count;
        }

        public String getValue() {
            return this.value;
        }

        public Long getVersion() {
            return this.version;
        }

        public Integer getIndex() {
            return this.index;
        }
    }
}

