/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.featureprobe.sdk.server.AccessEvent;
import com.featureprobe.sdk.server.AccessRecorder;
import com.featureprobe.sdk.server.Event;
import com.featureprobe.sdk.server.EventProcessor;
import com.featureprobe.sdk.server.FPContext;
import com.featureprobe.sdk.server.Loggers;
import com.featureprobe.sdk.server.exceptions.HttpErrorException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;

public class DefaultEventProcessor
implements EventProcessor {
    private static final Logger logger = Loggers.EVENT;
    private static final String GET_SDK_KEY_HEADER = "Authorization";
    private static final int EVENT_BATCH_HANDLE_SIZE = 50;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    @VisibleForTesting
    private final BlockingQueue<EventAction> eventQueue;
    private final ScheduledExecutorService scheduler;
    private final int capacity = 10000;
    private final ExecutorService executor;
    ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FeatureProbe-event-handle-%d").setPriority(1).build();

    DefaultEventProcessor(FPContext context) {
        this.eventQueue = new ArrayBlockingQueue<EventAction>(10000);
        this.executor = new ThreadPoolExecutor(1, 5, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), this.threadFactory);
        EventRepository eventRepository = new EventRepository();
        Thread eventHandleThread = this.threadFactory.newThread(() -> this.handleEvent(context, this.eventQueue, eventRepository));
        eventHandleThread.setDaemon(true);
        eventHandleThread.start();
        Runnable flusher = () -> this.flush();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
        this.scheduler.scheduleAtFixedRate(flusher, 0L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public void push(Event event) {
        boolean success;
        if (!this.closed.get() && !(success = this.eventQueue.offer(new EventAction(EventActionType.EVENT, event)))) {
            logger.warn("Event processing is busy, some will be dropped");
        }
    }

    @Override
    public void flush() {
        if (!this.closed.get() && !this.eventQueue.offer(new EventAction(EventActionType.FLUSH, null))) {
            logger.warn("Event processing is busy, some will be dropped");
        }
    }

    @Override
    public void shutdown() {
        if (this.closed.compareAndSet(false, true)) {
            this.eventQueue.offer(new EventAction(EventActionType.FLUSH, null));
            this.eventQueue.offer(new EventAction(EventActionType.SHUTDOWN, null));
        }
    }

    private void handleEvent(FPContext context, BlockingQueue<EventAction> eventQueue, EventRepository eventRepository) {
        ArrayList<EventAction> actions = new ArrayList<EventAction>(50);
        while (!this.closed.get() || !eventQueue.isEmpty()) {
            try {
                actions.clear();
                actions.add(eventQueue.take());
                eventQueue.drainTo(actions, 49);
                for (EventAction action : actions) {
                    switch (action.type) {
                        case EVENT: {
                            this.processEvent(action.event, eventRepository);
                            break;
                        }
                        case FLUSH: {
                            this.processFlush(context, eventRepository);
                            break;
                        }
                        case SHUTDOWN: {
                            this.doShutdown();
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("FeatureProbe event handle error: {}", (Throwable)e);
            }
        }
    }

    private void doShutdown() {
        this.scheduler.shutdown();
    }

    private void processEvent(Event event, EventRepository eventRepository) {
        eventRepository.add(event);
    }

    private void processFlush(FPContext context, EventRepository eventRepository) {
        if (eventRepository.isEmpty()) {
            return;
        }
        ArrayList<EventRepository> sendQueue = new ArrayList<EventRepository>();
        sendQueue.add(eventRepository.snapshot());
        SendEventsTask task = new SendEventsTask(context, sendQueue);
        this.executor.submit(task);
        eventRepository.clear();
    }

    private static enum EventActionType {
        EVENT,
        FLUSH,
        SHUTDOWN;

    }

    private static final class EventAction {
        private final EventActionType type;
        private final Event event;

        public EventAction(EventActionType type, Event event) {
            this.type = type;
            this.event = event;
        }
    }

    private static final class EventRepository {
        List<Event> events = new ArrayList<Event>();
        AccessRecorder access = new AccessRecorder();

        public EventRepository() {
        }

        private EventRepository(EventRepository eventRepository) {
            this.events = eventRepository.events;
            this.access = eventRepository.access.snapshot();
        }

        boolean isEmpty() {
            return this.events.isEmpty() && this.access.counters.isEmpty();
        }

        void add(Event event) {
            if (event instanceof AccessEvent) {
                this.access.add(event);
            }
        }

        EventRepository snapshot() {
            return new EventRepository(this);
        }

        void clear() {
            this.events.clear();
            this.access.clear();
        }

        public List<Event> getEvents() {
            return this.events;
        }

        public AccessRecorder getAccess() {
            return this.access;
        }
    }

    private static final class SendEventsTask
    implements Runnable {
        private final ObjectMapper mapper = new ObjectMapper();
        private final URL apiUrl;
        private final Headers headers;
        private final OkHttpClient httpClient;
        private final List<EventRepository> repositories;

        SendEventsTask(FPContext context, List<EventRepository> repositories) {
            this.apiUrl = context.getEventUrl();
            Headers.Builder headerBuilder = new Headers.Builder();
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(context.getHttpConfiguration().connectionPool).connectTimeout(context.getHttpConfiguration().connectTimeout).readTimeout(context.getHttpConfiguration().readTimeout).writeTimeout(context.getHttpConfiguration().writeTimeout).retryOnConnectionFailure(false);
            this.httpClient = builder.build();
            this.headers = headerBuilder.add(DefaultEventProcessor.GET_SDK_KEY_HEADER, context.getServerSdkKey()).build();
            this.repositories = repositories;
        }

        @Override
        public void run() {
            Request request;
            try {
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.mapper.writeValueAsString(this.repositories));
                request = new Request.Builder().url(this.apiUrl.toString()).headers(this.headers).post(requestBody).build();
            }
            catch (Exception e) {
                logger.error("Unexpected error from event sender: {}", (Object)e.toString());
                return;
            }
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new HttpErrorException("Http request error : " + response.code());
                }
                logger.debug("Http response : " + response.toString());
            }
            catch (Exception e) {
                logger.error("Unexpected error from event sender: {}", (Object)e.toString());
            }
        }
    }
}

