/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server;

import com.featureprobe.sdk.server.FPConfig;
import com.featureprobe.sdk.server.HttpConfiguration;
import com.featureprobe.sdk.server.Loggers;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;
import org.slf4j.Logger;

final class FPContext {
    private static final Logger logger = Loggers.MAIN;
    private static final String GET_REPOSITORY_DATA_API = "/api/server-sdk/toggles";
    private static final String POST_EVENTS_DATA_API = "/api/events";
    private URL synchronizerUrl;
    private URL eventUrl;
    private final String serverSdkKey;
    private final Duration refreshInterval;
    private final String location;
    private final HttpConfiguration httpConfiguration;

    FPContext(String serverSdkKey, FPConfig config) {
        try {
            this.synchronizerUrl = Objects.isNull(config.synchronizerUrl) ? new URL(config.remoteUri.toString() + GET_REPOSITORY_DATA_API) : config.synchronizerUrl;
            this.eventUrl = Objects.isNull(config.eventUrl) ? new URL(config.remoteUri.toString() + POST_EVENTS_DATA_API) : config.eventUrl;
        }
        catch (MalformedURLException e) {
            logger.error("construction context error", (Throwable)e);
        }
        this.serverSdkKey = serverSdkKey;
        this.refreshInterval = config.refreshInterval;
        this.location = config.location;
        this.httpConfiguration = config.httpConfiguration;
    }

    public URL getSynchronizerUrl() {
        return this.synchronizerUrl;
    }

    public URL getEventUrl() {
        return this.eventUrl;
    }

    public String getServerSdkKey() {
        return this.serverSdkKey;
    }

    public Duration getRefreshInterval() {
        return this.refreshInterval;
    }

    public String getLocation() {
        return this.location;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }
}

