/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server.model;

import com.featureprobe.sdk.server.FPUser;
import com.featureprobe.sdk.server.Matcher;
import com.featureprobe.sdk.server.model.ConditionType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class Condition {
    private ConditionType type;
    private String subject;
    private String predicate;
    private List<String> objects;
    private static final Map<String, Matcher> matchers = new HashMap<String, Matcher>(10);

    public boolean matchObjects(FPUser user) {
        String subjectValue = user.getAttrs().get(this.subject);
        if (StringUtils.isBlank((CharSequence)subjectValue)) {
            return false;
        }
        switch (this.type) {
            case STRING: {
                return this.matchStringCondition(subjectValue);
            }
        }
        return false;
    }

    private boolean matchStringCondition(String subjectValue) {
        Matcher matcher = matchers.get(this.predicate);
        if (Objects.nonNull(matcher)) {
            return matcher.match(subjectValue, this.objects);
        }
        return false;
    }

    public ConditionType getType() {
        return this.type;
    }

    public void setType(ConditionType type) {
        this.type = type;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    public List<String> getObjects() {
        return this.objects;
    }

    public void setObjects(List<String> objects) {
        this.objects = objects;
    }

    static {
        matchers.put("is one of", (target, objects) -> objects.contains(target));
        matchers.put("ends with", (target, objects) -> objects.stream().filter(s -> target.endsWith((String)s)).findAny().isPresent());
        matchers.put("starts with", (target, objects) -> objects.stream().filter(s -> target.startsWith((String)s)).findAny().isPresent());
        matchers.put("contains", (target, objects) -> objects.stream().filter(s -> target.indexOf((String)s) != -1).findAny().isPresent());
        matchers.put("matches regex", (target, objects) -> objects.stream().filter(s -> Pattern.compile(s).matcher(target).find()).findAny().isPresent());
        matchers.put("is not any of", (target, objects) -> !objects.contains(target));
        matchers.put("does not end with", (target, objects) -> !objects.stream().filter(s -> target.endsWith((String)s)).findAny().isPresent());
        matchers.put("does not start with", (target, objects) -> !objects.stream().filter(s -> target.startsWith((String)s)).findAny().isPresent());
        matchers.put("does not contain", (target, objects) -> !objects.stream().filter(s -> target.indexOf((String)s) != -1).findAny().isPresent());
        matchers.put("does not match regex", (target, objects) -> !objects.stream().filter(s -> Pattern.compile(s).matcher(target).find()).findAny().isPresent());
    }
}

