/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server.model;

import com.featureprobe.sdk.server.FPUser;
import com.featureprobe.sdk.server.HitResult;
import com.featureprobe.sdk.server.model.Condition;
import com.featureprobe.sdk.server.model.Serve;
import java.util.List;
import java.util.Optional;

public final class Rule {
    private Serve serve;
    private List<Condition> conditions;

    public HitResult hit(FPUser user, String toggleKey) {
        for (Condition condition : this.conditions) {
            if (!user.containAttr(condition.getSubject())) {
                return new HitResult(false, Optional.of("Warning : User with key: " + user.getKey() + " does not have attribute name: " + condition.getSubject()));
            }
            if (condition.matchObjects(user)) continue;
            return new HitResult(false);
        }
        return this.serve.evalIndex(user, toggleKey);
    }

    public Rule() {
    }

    public Rule(Serve serve, List<Condition> conditions) {
        this.serve = serve;
        this.conditions = conditions;
    }

    public Serve getServe() {
        return this.serve;
    }

    public void setServe(Serve serve) {
        this.serve = serve;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }
}

