/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.featureprobe.sdk.server.DataRepository;
import com.featureprobe.sdk.server.Loggers;
import com.featureprobe.sdk.server.Synchronizer;
import com.featureprobe.sdk.server.model.Repository;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;

final class FileSynchronizer
implements Synchronizer {
    private static final Logger logger = Loggers.SYNCHRONIZER;
    DataRepository dataRepository;
    static final String DEFAULT_LOCATION = "datasource/repo.json";
    final String location;
    final ObjectMapper mapper = new ObjectMapper();

    FileSynchronizer(DataRepository dataRepository, String location) {
        this.dataRepository = dataRepository;
        this.location = location == null ? DEFAULT_LOCATION : location;
    }

    @Override
    public void sync() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.location);){
            String data;
            if (is == null) {
                logger.error("repository file resource not found in classpath: {}", (Object)this.location);
                data = "";
            } else {
                data = new String(ByteStreams.toByteArray((InputStream)is), StandardCharsets.UTF_8);
            }
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Repository repository = (Repository)this.mapper.readValue(data, Repository.class);
            this.dataRepository.refresh(repository);
        }
        catch (IOException e) {
            logger.error("repository file resource not found in classpath: {}", (Object)this.location, (Object)e);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

