/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.featureprobe.sdk.server.AccessEvent;
import com.featureprobe.sdk.server.CustomEvent;
import com.featureprobe.sdk.server.DataRepository;
import com.featureprobe.sdk.server.EvaluationResult;
import com.featureprobe.sdk.server.Event;
import com.featureprobe.sdk.server.EventProcessor;
import com.featureprobe.sdk.server.FPConfig;
import com.featureprobe.sdk.server.FPContext;
import com.featureprobe.sdk.server.FPDetail;
import com.featureprobe.sdk.server.FPUser;
import com.featureprobe.sdk.server.Loggers;
import com.featureprobe.sdk.server.Synchronizer;
import com.featureprobe.sdk.server.model.Segment;
import com.featureprobe.sdk.server.model.Toggle;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public final class FeatureProbe {
    private static final Logger logger = Loggers.MAIN;
    private final ObjectMapper mapper = new ObjectMapper();
    private static final String REASON_TYPE_MISMATCH = "Toggle data type mismatch";
    private static final String REASON_HANDLE_ERROR = "FeatureProbe handle error";
    private static final String LOG_HANDLE_ERROR = "FeatureProbe handle error. toggleKey: {}";
    private static final String LOG_CONVERSION_ERROR = "Toggle data type conversion error. toggleKey: {}";
    @VisibleForTesting
    final DataRepository dataRepository;
    @VisibleForTesting
    Synchronizer synchronizer;
    @VisibleForTesting
    EventProcessor eventProcessor;

    @VisibleForTesting
    private FeatureProbe(DataRepository dataRepository) {
        this.dataRepository = dataRepository;
        FPConfig config = FPConfig.DEFAULT;
        FPContext context = new FPContext("test", config);
        this.eventProcessor = config.eventProcessorFactory.createEventProcessor(context);
    }

    public FeatureProbe(String serverSDKKey) {
        this(serverSDKKey, FPConfig.DEFAULT);
    }

    public FeatureProbe(String serverSDKKey, FPConfig config) {
        if (StringUtils.isBlank(serverSDKKey)) {
            throw new IllegalArgumentException("serverSDKKey must not be blank");
        }
        FPContext context = new FPContext(serverSDKKey, config);
        this.eventProcessor = config.eventProcessorFactory.createEventProcessor(context);
        this.dataRepository = config.dataRepositoryFactory.createDataRepository(context);
        this.synchronizer = config.synchronizerFactory.createSynchronizer(context, this.dataRepository);
        Future<Void> startFuture = this.synchronizer.sync();
        try {
            startFuture.get(config.startWait, TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            logger.error("Timeout encountered waiting for FeatureProbe client initialization");
        }
        catch (Exception e) {
            logger.error("Exception encountered waiting for FeatureProbe client initialization", e);
        }
        if (!this.dataRepository.initialized()) {
            logger.warn("FeatureProbe client was not successfully initialized");
        }
    }

    public boolean boolValue(String toggleKey, FPUser user, boolean defaultValue) {
        return this.genericEvaluate(toggleKey, user, defaultValue, Boolean.class);
    }

    public String stringValue(String toggleKey, FPUser user, String defaultValue) {
        return this.genericEvaluate(toggleKey, user, defaultValue, String.class);
    }

    public double numberValue(String toggleKey, FPUser user, double defaultValue) {
        return this.genericEvaluate(toggleKey, user, defaultValue, Double.class);
    }

    public <T> T jsonValue(String toggleKey, FPUser user, T defaultValue, Class<T> clazz) {
        return this.jsonEvaluate(toggleKey, user, defaultValue, clazz);
    }

    public FPDetail<Boolean> boolDetail(String toggleKey, FPUser user, boolean defaultValue) {
        return this.genericEvaluateDetail(toggleKey, user, defaultValue, Boolean.class);
    }

    public FPDetail<String> stringDetail(String toggleKey, FPUser user, String defaultValue) {
        return this.genericEvaluateDetail(toggleKey, user, defaultValue, String.class);
    }

    public FPDetail<Double> numberDetail(String toggleKey, FPUser user, double defaultValue) {
        return this.genericEvaluateDetail(toggleKey, user, defaultValue, Double.class);
    }

    public <T> FPDetail<T> jsonDetail(String toggleKey, FPUser user, T defaultValue, Class<T> clazz) {
        return this.jsonEvaluateDetail(toggleKey, user, defaultValue, clazz);
    }

    public void flush() {
        this.eventProcessor.flush();
    }

    public void close() throws IOException {
        logger.info("Closing FeatureProbe Client\u3002");
        this.eventProcessor.shutdown();
        this.synchronizer.close();
        this.dataRepository.close();
    }

    public boolean initialized() {
        return this.dataRepository.initialized();
    }

    public void track(String eventName, FPUser user) {
        this.eventProcessor.push(new CustomEvent(eventName, user.getKey(), null));
    }

    public void track(String eventName, FPUser user, double value) {
        this.eventProcessor.push(new CustomEvent(eventName, user.getKey(), value));
    }

    private <T> T jsonEvaluate(String toggleKey, FPUser user, T defaultValue, Class<T> clazz) {
        try {
            Toggle toggle = this.dataRepository.getToggle(toggleKey);
            Map<String, Segment> segments = this.dataRepository.getAllSegment();
            if (Objects.nonNull(toggle)) {
                EvaluationResult evalResult = toggle.eval(user, segments, defaultValue);
                String value = this.mapper.writeValueAsString(evalResult.getValue());
                this.eventProcessor.push(this.buildAccessEvent(toggle, evalResult, user));
                return this.mapper.readValue(value, clazz);
            }
        }
        catch (JsonProcessingException e) {
            logger.error(LOG_CONVERSION_ERROR, (Object)toggleKey, (Object)e);
        }
        catch (Exception e) {
            logger.error(LOG_HANDLE_ERROR, (Object)toggleKey, (Object)e);
        }
        return defaultValue;
    }

    private <T> T genericEvaluate(String toggleKey, FPUser user, T defaultValue, Class<T> clazz) {
        try {
            Toggle toggle = this.dataRepository.getToggle(toggleKey);
            Map<String, Segment> segments = this.dataRepository.getAllSegment();
            if (Objects.nonNull(toggle)) {
                EvaluationResult evalResult = toggle.eval(user, segments, defaultValue);
                this.eventProcessor.push(this.buildAccessEvent(toggle, evalResult, user));
                return clazz.cast(evalResult.getValue());
            }
        }
        catch (ClassCastException e) {
            logger.error(LOG_CONVERSION_ERROR, (Object)toggleKey, (Object)e);
        }
        catch (Exception e) {
            logger.error(LOG_HANDLE_ERROR, (Object)toggleKey, (Object)e);
        }
        return defaultValue;
    }

    private <T> FPDetail<T> jsonEvaluateDetail(String toggleKey, FPUser user, T defaultValue, Class<T> clazz) {
        FPDetail<T> detail = new FPDetail<T>();
        try {
            return this.getEvaluateDetail(toggleKey, user, defaultValue, clazz, true);
        }
        catch (JsonProcessingException | ClassCastException e) {
            logger.error(LOG_CONVERSION_ERROR, (Object)toggleKey, (Object)e);
            detail.setReason(REASON_TYPE_MISMATCH);
        }
        catch (Exception e) {
            logger.error(LOG_HANDLE_ERROR, (Object)toggleKey, (Object)e);
            detail.setReason(REASON_HANDLE_ERROR);
        }
        detail.setValue(defaultValue);
        return detail;
    }

    private <T> FPDetail<T> genericEvaluateDetail(String toggleKey, FPUser user, T defaultValue, Class<T> clazz) {
        FPDetail<T> detail = new FPDetail<T>();
        try {
            return this.getEvaluateDetail(toggleKey, user, defaultValue, clazz, false);
        }
        catch (JsonProcessingException | ClassCastException e) {
            logger.error(LOG_CONVERSION_ERROR, (Object)toggleKey, (Object)e);
            detail.setReason(REASON_TYPE_MISMATCH);
        }
        catch (Exception e) {
            logger.error(LOG_HANDLE_ERROR, (Object)toggleKey, (Object)e);
            detail.setReason(REASON_HANDLE_ERROR);
        }
        detail.setValue(defaultValue);
        return detail;
    }

    private <T> FPDetail<T> getEvaluateDetail(String toggleKey, FPUser user, T defaultValue, Class<T> clazz, boolean isJson) throws ClassCastException, JsonProcessingException {
        FPDetail<T> detail = new FPDetail<T>();
        if (this.dataRepository.initialized()) {
            Toggle toggle = this.dataRepository.getToggle(toggleKey);
            Map<String, Segment> segments = this.dataRepository.getAllSegment();
            if (Objects.nonNull(toggle)) {
                EvaluationResult evalResult = toggle.eval(user, segments, defaultValue);
                if (isJson) {
                    String res = this.mapper.writeValueAsString(evalResult.getValue());
                    detail.setValue(this.mapper.readValue(res, clazz));
                } else {
                    detail.setValue(clazz.cast(evalResult.getValue()));
                }
                detail.setReason(evalResult.getReason());
                detail.setRuleIndex(evalResult.getRuleIndex());
                detail.setVersion(Optional.of(evalResult.getVersion()));
                this.eventProcessor.push(this.buildAccessEvent(toggle, evalResult, user));
            } else {
                detail.setReason("Toggle not exist");
                detail.setValue(defaultValue);
            }
        } else {
            detail.setReason("FeatureProbe repository uninitialized");
            detail.setValue(defaultValue);
        }
        return detail;
    }

    private Event buildAccessEvent(Toggle toggle, EvaluationResult evalResult, FPUser user) {
        boolean trackAccessEvents = Objects.isNull(toggle.getTrackAccessEvents()) ? false : toggle.getTrackAccessEvents();
        return new AccessEvent(user.getKey(), toggle.getKey(), evalResult.getValue(), evalResult.getVersion(), evalResult.getVariationIndex().orElse(null), evalResult.getRuleIndex().orElse(null), evalResult.getReason(), trackAccessEvents);
    }
}

