/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.featureprobe.sdk.server.DataRepository;
import com.featureprobe.sdk.server.Loggers;
import com.featureprobe.sdk.server.Synchronizer;
import com.featureprobe.sdk.server.model.Repository;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.slf4j.Logger;

final class FileSynchronizer
implements Synchronizer {
    private static final Logger logger = Loggers.SYNCHRONIZER;
    private final CompletableFuture<Void> initFuture;
    DataRepository dataRepository;
    static final String DEFAULT_LOCATION = "datasource/repo.json";
    final String location;
    final ObjectMapper mapper = new ObjectMapper();

    FileSynchronizer(DataRepository dataRepository, String location) {
        this.dataRepository = dataRepository;
        this.initFuture = new CompletableFuture();
        this.location = location == null ? DEFAULT_LOCATION : location;
    }

    @Override
    public Future<Void> sync() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.location);){
            String data;
            if (is == null) {
                logger.error("repository file resource not found in classpath: {}", (Object)this.location);
                data = "";
            } else {
                data = new String(ByteStreams.toByteArray(is), StandardCharsets.UTF_8);
            }
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Repository repository = this.mapper.readValue(data, Repository.class);
            this.dataRepository.refresh(repository);
        }
        catch (IOException e) {
            logger.error("repository file resource not found in classpath: {}", (Object)this.location, (Object)e);
        }
        return this.initFuture;
    }

    @Override
    public void close() throws IOException {
    }
}

