/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.featureprobe.sdk.server.AccessEvent;
import com.featureprobe.sdk.server.AccessSummaryRecorder;
import com.featureprobe.sdk.server.CustomEvent;
import com.featureprobe.sdk.server.Event;
import com.featureprobe.sdk.server.EventProcessor;
import com.featureprobe.sdk.server.FPContext;
import com.featureprobe.sdk.server.Loggers;
import com.featureprobe.sdk.server.exceptions.HttpErrorException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;

public class DefaultEventProcessor
implements EventProcessor {
    private static final Logger logger = Loggers.EVENT;
    private static final int EVENT_BATCH_HANDLE_SIZE = 50;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    @VisibleForTesting
    private final BlockingQueue<EventAction> eventQueue;
    private final ScheduledExecutorService scheduler;
    private final int capacity = 10000;
    private final ExecutorService executor;
    private final Thread eventHandleThread;
    final EventRepository eventRepository = new EventRepository();
    final List<EventAction> actions = new ArrayList<EventAction>(50);
    FPContext context;
    private static final String LOG_SENDER_ERROR = "Unexpected error from event sender";
    private static final String LOG_BUSY_EVENT = "Event processing is busy, some will be dropped";
    ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FeatureProbe-event-handle-%d").setPriority(1).build();

    DefaultEventProcessor(FPContext context) {
        this.context = context;
        this.eventQueue = new ArrayBlockingQueue<EventAction>(10000);
        this.executor = new ThreadPoolExecutor(1, 5, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), this.threadFactory);
        this.eventHandleThread = this.threadFactory.newThread(() -> this.handleEvent(context, this.eventQueue, this.eventRepository));
        this.eventHandleThread.setDaemon(true);
        this.eventHandleThread.start();
        Runnable flusher = this::flush;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
        this.scheduler.scheduleAtFixedRate(flusher, 0L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public void push(Event event) {
        boolean success;
        if (!this.closed.get() && !(success = this.eventQueue.offer(new EventAction(EventActionType.EVENT, event)))) {
            logger.warn(LOG_BUSY_EVENT);
        }
    }

    @Override
    public void flush() {
        if (!this.closed.get() && !this.eventQueue.offer(new EventAction(EventActionType.FLUSH, null))) {
            logger.warn(LOG_BUSY_EVENT);
        }
    }

    @Override
    public void shutdown() {
        this.flush();
        this.doShutdown();
    }

    private void handleEvent(FPContext context, BlockingQueue<EventAction> eventQueue, EventRepository eventRepository) {
        while (!this.closed.get() || !eventQueue.isEmpty()) {
            try {
                this.actions.clear();
                this.actions.add(eventQueue.take());
                eventQueue.drainTo(this.actions, 49);
                for (EventAction action : this.actions) {
                    switch (action.type) {
                        case EVENT: {
                            this.processEvent(action.event, eventRepository);
                            break;
                        }
                        case FLUSH: {
                            this.processFlush(context, eventRepository);
                            break;
                        }
                        case SHUTDOWN: {
                            this.doShutdown();
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("FeatureProbe event handle error", e);
            }
        }
    }

    private void doShutdown() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.eventHandleThread.join(2000L);
                this.scheduler.awaitTermination(1000L, TimeUnit.MILLISECONDS);
                this.executor.awaitTermination(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.error("FeatureProbe shutdown error", e);
            }
        }
    }

    private void processEvent(Event event, EventRepository eventRepository) {
        eventRepository.add(event);
    }

    private void processFlush(FPContext context, EventRepository eventRepository) {
        if (eventRepository.isEmpty()) {
            return;
        }
        ArrayList<EventRepository> sendQueue = new ArrayList<EventRepository>();
        sendQueue.add(eventRepository.snapshot());
        SendEventsTask task = new SendEventsTask(context, sendQueue);
        this.executor.submit(task);
        eventRepository.clear();
    }

    private static enum EventActionType {
        EVENT,
        FLUSH,
        SHUTDOWN;

    }

    private static final class EventAction {
        private final EventActionType type;
        private final Event event;

        public EventAction(EventActionType type, Event event) {
            this.type = type;
            this.event = event;
        }
    }

    private static final class EventRepository {
        List<Event> events = new ArrayList<Event>();
        AccessSummaryRecorder access = new AccessSummaryRecorder();

        public EventRepository() {
        }

        private EventRepository(EventRepository repository) {
            this.events = new ArrayList<Event>(repository.events);
            this.access = repository.access.snapshot();
        }

        boolean isEmpty() {
            return this.events.isEmpty() && this.access.counters.isEmpty();
        }

        void add(Event event) {
            if (event instanceof AccessEvent) {
                this.access.add(event);
                if (((AccessEvent)event).isTrackAccessEvents()) {
                    this.events.add(event);
                }
            } else if (event instanceof CustomEvent) {
                this.events.add(event);
            }
        }

        EventRepository snapshot() {
            return new EventRepository(this);
        }

        void clear() {
            this.events.clear();
            this.access.clear();
        }

        public List<Event> getEvents() {
            return this.events;
        }

        public AccessSummaryRecorder getAccess() {
            return this.access;
        }
    }

    private static final class SendEventsTask
    implements Runnable {
        private final ObjectMapper mapper = new ObjectMapper();
        private final URL apiUrl;
        private final Headers headers;
        private final OkHttpClient httpClient;
        private final List<EventRepository> repositories;

        SendEventsTask(FPContext context, List<EventRepository> repositories) {
            this.apiUrl = context.getEventUrl();
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(context.getHttpConfiguration().connectionPool).connectTimeout(context.getHttpConfiguration().connectTimeout).readTimeout(context.getHttpConfiguration().readTimeout).writeTimeout(context.getHttpConfiguration().writeTimeout).retryOnConnectionFailure(false);
            this.httpClient = builder.build();
            this.headers = context.getHeaders();
            this.repositories = repositories;
        }

        @Override
        public void run() {
            Request request;
            try {
                RequestBody requestBody = RequestBody.create(MediaType.parse("application/json"), this.mapper.writeValueAsString(this.repositories));
                request = new Request.Builder().url(this.apiUrl.toString()).headers(this.headers).post(requestBody).build();
            }
            catch (Exception e) {
                logger.error(DefaultEventProcessor.LOG_SENDER_ERROR, e);
                return;
            }
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new HttpErrorException("Http request error: " + response.code());
                }
                logger.debug("Http response: {}", (Object)response);
            }
            catch (Exception e) {
                logger.error(DefaultEventProcessor.LOG_SENDER_ERROR, e);
            }
        }
    }
}

