/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server;

import com.featureprobe.sdk.server.FPConfig;
import com.featureprobe.sdk.server.HttpConfiguration;
import com.featureprobe.sdk.server.Loggers;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;
import java.util.Properties;
import okhttp3.Headers;
import org.slf4j.Logger;

final class FPContext {
    private static final Logger logger = Loggers.MAIN;
    private static final String GET_SDK_KEY_HEADER = "Authorization";
    private static final String USER_AGENT_HEADER = "user-agent";
    private static final String DEFAULT_SDK_VERSION = "unknown";
    private static final String SDK_FLAG_PREFIX = "Java/";
    private static final String GET_REPOSITORY_DATA_API = "/api/server-sdk/toggles";
    private static final String POST_EVENTS_DATA_API = "/api/events";
    private static final String REALTIME_URI_PATH = "/realtime";
    private URL synchronizerUrl;
    private URI realtimeUri;
    private URL eventUrl;
    private final String serverSdkKey;
    private final Duration refreshInterval;
    private final String location;
    private final HttpConfiguration httpConfiguration;
    private final Headers headers;

    FPContext(String serverSdkKey, FPConfig config) {
        try {
            this.synchronizerUrl = Objects.isNull(config.synchronizerUrl) ? new URL(config.remoteUri.toString() + GET_REPOSITORY_DATA_API) : config.synchronizerUrl;
            this.eventUrl = Objects.isNull(config.eventUrl) ? new URL(config.remoteUri.toString() + POST_EVENTS_DATA_API) : config.eventUrl;
            this.realtimeUri = Objects.isNull(config.realtimeUri) ? new URI(config.remoteUri.toString() + REALTIME_URI_PATH) : config.realtimeUri;
        }
        catch (MalformedURLException e) {
            logger.error("construction context error", e);
        }
        catch (URISyntaxException e) {
            logger.error("construction context error", e);
        }
        this.serverSdkKey = serverSdkKey;
        this.refreshInterval = config.refreshInterval;
        this.location = config.location;
        this.httpConfiguration = config.httpConfiguration;
        String sdkVersion = this.getVersion();
        this.headers = config.httpConfiguration.headers.newBuilder().add(GET_SDK_KEY_HEADER, serverSdkKey).add(USER_AGENT_HEADER, SDK_FLAG_PREFIX + sdkVersion).build();
    }

    public URL getSynchronizerUrl() {
        return this.synchronizerUrl;
    }

    public URL getEventUrl() {
        return this.eventUrl;
    }

    public String getServerSdkKey() {
        return this.serverSdkKey;
    }

    public Duration getRefreshInterval() {
        return this.refreshInterval;
    }

    public String getLocation() {
        return this.location;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    private synchronized String getVersion() {
        Package aPackage;
        String version = null;
        try {
            Properties p = new Properties();
            InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/com.featureprobe/server-sdk-java/pom.properties");
            if (is != null) {
                p.load(is);
                version = p.getProperty("version", DEFAULT_SDK_VERSION);
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        if (version == null && (aPackage = this.getClass().getPackage()) != null && (version = aPackage.getImplementationVersion()) == null) {
            version = aPackage.getSpecificationVersion();
        }
        if (version == null) {
            version = DEFAULT_SDK_VERSION;
        }
        return version;
    }

    public URI getRealtimeUri() {
        return this.realtimeUri;
    }
}

