/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.featureprobe.sdk.server.DataRepository;
import com.featureprobe.sdk.server.FPContext;
import com.featureprobe.sdk.server.Loggers;
import com.featureprobe.sdk.server.Synchronizer;
import com.featureprobe.sdk.server.exceptions.HttpErrorException;
import com.featureprobe.sdk.server.model.Repository;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;

final class PollingSynchronizer
implements Synchronizer {
    private static final Logger logger = Loggers.SYNCHRONIZER;
    private static final String GET_SDK_KEY_HEADER = "Authorization";
    final ObjectMapper mapper = new ObjectMapper();
    DataRepository dataRepository;
    private final Duration refreshInterval;
    private final URL apiUrl;
    private volatile ScheduledFuture<?> worker;
    private final OkHttpClient httpClient;
    private final Headers headers;
    private final CompletableFuture<Void> initFuture;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FeatureProbe-Synchronizer-%d").setPriority(1).build());

    PollingSynchronizer(FPContext context, DataRepository dataRepository) {
        this.refreshInterval = context.getRefreshInterval();
        this.apiUrl = context.getSynchronizerUrl();
        this.dataRepository = dataRepository;
        this.initFuture = new CompletableFuture();
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(context.getHttpConfiguration().connectionPool).connectTimeout(context.getHttpConfiguration().connectTimeout).readTimeout(context.getHttpConfiguration().readTimeout).writeTimeout(context.getHttpConfiguration().writeTimeout).retryOnConnectionFailure(false);
        this.headers = context.getHeaders();
        this.httpClient = builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> sync() {
        logger.info("starting FeatureProbe polling repository with interval {} ms", (Object)this.refreshInterval.toMillis());
        PollingSynchronizer pollingSynchronizer = this;
        synchronized (pollingSynchronizer) {
            if (this.worker == null) {
                this.worker = this.scheduler.scheduleAtFixedRate(this::poll, 0L, this.refreshInterval.toMillis(), TimeUnit.MILLISECONDS);
            }
        }
        return this.initFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        logger.info("Closing FeatureProbe PollingSynchronizer");
        PollingSynchronizer pollingSynchronizer = this;
        synchronized (pollingSynchronizer) {
            if (this.worker != null) {
                this.worker.cancel(true);
                this.worker = null;
            }
        }
    }

    public void poll() {
        Request request = new Request.Builder().url(this.apiUrl.toString()).headers(this.headers).get().build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String body = response.body().string();
            if (!response.isSuccessful()) {
                throw new HttpErrorException(String.format("Http request error: code: {}, body: {}:" + response.code(), response.body()));
            }
            logger.debug("Http response: {}", (Object)response);
            logger.debug("Http response body: {}", (Object)body);
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Repository repository = this.mapper.readValue(body, Repository.class);
            this.dataRepository.refresh(repository);
            this.initFuture.complete(null);
        }
        catch (Exception e) {
            logger.error("Unexpected error from polling processor", e);
        }
    }
}

