/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.java.utils;

import com.feedzai.openml.provider.exception.ModelLoadingException;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFileUtils {
    private static final Logger logger = LoggerFactory.getLogger(JavaFileUtils.class);
    public static final String JAR_EXTENSION = "jar";
    public static final String JAVA_FILE_EXTENSION = "java";
    private static final String JAVA_COMPILED_EXTENSION = "class";

    private JavaFileUtils() {
    }

    public static URLClassLoader getUrlClassLoader(String modelPath, ClassLoader classLoader) throws ModelLoadingException {
        URL resourceURL;
        try {
            resourceURL = Paths.get(modelPath, new String[0]).toUri().toURL();
        }
        catch (MalformedURLException e) {
            logger.error("Could not get the path of the model [{}].", (Object)modelPath, (Object)e);
            throw new ModelLoadingException(String.format("An error was found when getting the path of the model [%s]", modelPath), (Throwable)e);
        }
        return URLClassLoader.newInstance(new URL[]{resourceURL}, classLoader);
    }

    public static Object createNewInstanceFromClassLoader(String modelPath, String simpleNameFormat, URLClassLoader urlClassLoader) throws ModelLoadingException {
        try {
            String simpleNameJar = FilenameUtils.getBaseName((String)modelPath);
            return urlClassLoader.loadClass(String.format(simpleNameFormat, simpleNameJar)).newInstance();
        }
        catch (Exception e) {
            logger.error("Could not load the model [{}].", (Object)modelPath, (Object)e);
            throw new ModelLoadingException(String.format("An error was found during the import of the model [%s]", modelPath), (Throwable)e);
        }
    }

    public static boolean isJarFile(String filePath) {
        return JAR_EXTENSION.equals(Files.getFileExtension((String)filePath));
    }

    public static JavaCompiler initCompiler() {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            logger.error("Cannot find the system Java compiler. Check that Sun JDK is included in the classpath.");
            throw new RuntimeException("Cannot find the system Java compiler. Check that Sun JDK is included in the classpath.");
        }
        return compiler;
    }

    public static void compileJavaFile(JavaCompiler compiler, String javaFile) {
        logger.info("Compiling Java file at {}.", (Object)javaFile);
        compiler.run(null, null, null, javaFile);
    }

    public static JarOutputStream createJar(Path directory, String filename) throws IOException {
        String resultingName = directory.resolve(filename + "." + JAR_EXTENSION).toString();
        logger.info("Writing resulting jar file to {}.", (Object)resultingName);
        FileOutputStream fout = new FileOutputStream(resultingName);
        return new JarOutputStream(fout);
    }

    public static boolean writeClassesToJar(Path exportDir, JarOutputStream jar) {
        File[] files = exportDir.toFile().listFiles((dir, filename) -> filename.endsWith(".class"));
        Arrays.stream((Object[])Objects.requireNonNull(files)).forEach(classFile -> {
            try {
                jar.putNextEntry(new JarEntry(classFile.getName()));
                Files.copy((File)classFile, (OutputStream)jar);
            }
            catch (IOException e) {
                String msg = String.format("Problem writing file %s to jar.", classFile.getName());
                logger.error(msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        });
        return true;
    }

    public static boolean cleanUnnecessaryFiles(Path exportDir) {
        File[] files = exportDir.toFile().listFiles((dir, filename) -> !filename.endsWith(".jar"));
        return Arrays.stream((Object[])Objects.requireNonNull(files)).allMatch(File::delete);
    }
}

