/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.java.utils;

import com.feedzai.openml.java.utils.ModelParameterUtils;
import com.feedzai.openml.provider.descriptor.MLAlgorithmDescriptor;
import com.feedzai.openml.provider.descriptor.ModelParameter;
import com.feedzai.openml.provider.descriptor.fieldtype.BooleanFieldType;
import com.feedzai.openml.provider.descriptor.fieldtype.ChoiceFieldType;
import com.feedzai.openml.provider.descriptor.fieldtype.FreeTextFieldType;
import com.feedzai.openml.provider.descriptor.fieldtype.ModelParameterType;
import com.feedzai.openml.provider.descriptor.fieldtype.NumericFieldType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import mockit.Expectations;
import mockit.Mocked;
import mockit.integration.junit4.JMockit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMockit.class)
public class ModelParameterUtilsTest {
    @Test
    public final void effectiveModelParameterValues(final @Mocked MLAlgorithmDescriptor mlAlgorithmDescriptor) {
        ImmutableMap expectedParams = ImmutableMap.of((Object)"param0", (Object)"false", (Object)"param2", (Object)"2.0", (Object)"param3", (Object)"3", (Object)"param1", (Object)"99", (Object)"param5", (Object)"100");
        new Expectations(){
            {
                mlAlgorithmDescriptor.getParameters();
                this.result = ImmutableSet.of((Object)new ModelParameter("param0", "", "", true, (ModelParameterType)new BooleanFieldType(false)), (Object)new ModelParameter("param1", "", "", true, (ModelParameterType)new FreeTextFieldType("1")), (Object)new ModelParameter("param2", "", "", true, (ModelParameterType)NumericFieldType.min((double)0.0, (NumericFieldType.ParameterConfigType)NumericFieldType.ParameterConfigType.INT, (double)2.0)), (Object)new ModelParameter("param3", "", "", true, (ModelParameterType)new ChoiceFieldType((Set)ImmutableSet.of((Object)"1", (Object)"2", (Object)"3"), "3")));
            }
        };
        Map effectiveParams = ModelParameterUtils.getEffectiveModelParameterValues((MLAlgorithmDescriptor)mlAlgorithmDescriptor, (Map)ImmutableMap.of((Object)"param1", (Object)"99", (Object)"param5", (Object)"100"));
        ((MapAssert)Assertions.assertThat((Map)effectiveParams).as("effective model parameter values", new Object[0])).isEqualTo((Object)expectedParams);
    }
}

