/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.java.utils;

import com.feedzai.openml.provider.descriptor.MLAlgorithmDescriptor;
import com.feedzai.openml.provider.descriptor.ModelParameter;
import com.feedzai.openml.provider.descriptor.fieldtype.BooleanFieldType;
import com.feedzai.openml.provider.descriptor.fieldtype.ChoiceFieldType;
import com.feedzai.openml.provider.descriptor.fieldtype.FreeTextFieldType;
import com.feedzai.openml.provider.descriptor.fieldtype.ModelParameterType;
import com.feedzai.openml.provider.descriptor.fieldtype.NumericFieldType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class ModelParameterUtils {
    private ModelParameterUtils() {
    }

    public static Map<String, String> getEffectiveModelParameterValues(MLAlgorithmDescriptor algorithm, Set<String> parameterNames, Map<String, String> newParams) {
        Map<String, String> defaultValues = ModelParameterUtils.getDefaultModelParameterValues(algorithm);
        HashMap<String, String> effectiveModelParameter = new HashMap<String, String>();
        defaultValues.entrySet().stream().filter(entry -> !newParams.containsKey(entry.getKey())).forEach(entry -> {
            String cfr_ignored_0 = (String)effectiveModelParameter.put((String)entry.getKey(), (String)entry.getValue());
        });
        parameterNames.stream().filter(newParams::containsKey).forEach(parameter -> {
            String cfr_ignored_0 = (String)effectiveModelParameter.put((String)parameter, (String)newParams.get(parameter));
        });
        return effectiveModelParameter;
    }

    private static Map<String, String> getDefaultModelParameterValues(MLAlgorithmDescriptor algorithm) {
        return algorithm.getParameters().stream().collect(Collectors.toMap(ModelParameter::getName, parameter -> ModelParameterUtils.getModelParameterTypeDefaultValue(parameter.getFieldType())));
    }

    private static String getModelParameterTypeDefaultValue(ModelParameterType fieldType) {
        if (fieldType instanceof FreeTextFieldType) {
            FreeTextFieldType freeTextFieldType = (FreeTextFieldType)fieldType;
            return freeTextFieldType.getDefaultValue();
        }
        if (fieldType instanceof NumericFieldType) {
            NumericFieldType numericFieldType = (NumericFieldType)fieldType;
            return String.valueOf(numericFieldType.getDefaultValue());
        }
        if (fieldType instanceof ChoiceFieldType) {
            ChoiceFieldType choiceFieldType = (ChoiceFieldType)fieldType;
            return choiceFieldType.getDefaultValue();
        }
        if (fieldType instanceof BooleanFieldType) {
            BooleanFieldType booleanFieldType = (BooleanFieldType)fieldType;
            return String.valueOf(booleanFieldType.isDefaultTrue());
        }
        throw new IllegalArgumentException(String.format("Unrecognized model parameter type [%s]", fieldType));
    }
}

