/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.flagsmith.Feature;
import com.flagsmith.Flag;
import com.flagsmith.FlagsAndTraits;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;

public class FlagsmithFlagDefaults {
    private Predicate<String> defaultFlagPredicate = flagName -> false;
    private Function<String, String> defaultFlagValueFunc = flagName -> null;
    private Set<String> defaultFeatureFlags = new HashSet<String>();

    public boolean evaluateDefaultFlagPredicate(String flagName) {
        return this.defaultFlagPredicate.test(flagName);
    }

    public void setDefaultFlagPredicate(@NonNull Predicate<String> defaultFlagPredicate) {
        if (defaultFlagPredicate == null) {
            throw new IllegalArgumentException("defaultFlagPredicate is marked non-null but is null");
        }
        this.defaultFlagPredicate = defaultFlagPredicate;
    }

    public String evaluateDefaultFlagValue(String flagName) {
        return this.defaultFlagValueFunc.apply(flagName);
    }

    public void setDefaultFlagValueFunc(@NonNull Function<String, String> defaultFlagValueFunc) {
        if (defaultFlagValueFunc == null) {
            throw new IllegalArgumentException("defaultFlagValueFunc is marked non-null but is null");
        }
        this.defaultFlagValueFunc = defaultFlagValueFunc;
    }

    public Set<String> getDefaultFeatureFlagNames() {
        return this.defaultFeatureFlags;
    }

    public void setDefaultFeatureFlags(@NonNull Set<String> defaultFeatureFlags) {
        if (defaultFeatureFlags == null) {
            throw new IllegalArgumentException("defaultFeatureFlags is marked non-null but is null");
        }
        this.defaultFeatureFlags = defaultFeatureFlags.stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    public List<Flag> getDefaultFlags() {
        return this.defaultFeatureFlags.stream().map(this::createDefaultFlag).collect(Collectors.toList());
    }

    public FlagsAndTraits enrichWithDefaultFlags(FlagsAndTraits flagsAndTraits) {
        if (flagsAndTraits.getFlags() == null) {
            flagsAndTraits.setFlags(new ArrayList<Flag>());
        }
        Set flagsNotFound = this.defaultFeatureFlags.stream().filter(defaultFlagName -> !this.isFlagWithNameFound(flagsAndTraits, (String)defaultFlagName)).collect(Collectors.toSet());
        for (String flagNameToBeAdded : flagsNotFound) {
            flagsAndTraits.getFlags().add(this.createDefaultFlag(flagNameToBeAdded));
        }
        return flagsAndTraits;
    }

    private boolean isFlagWithNameFound(FlagsAndTraits flagsAndTraits, String defaultFlagName) {
        return flagsAndTraits.getFlags().stream().anyMatch(existingFlag -> existingFlag.getFeature().getName().equals(defaultFlagName));
    }

    private Flag createDefaultFlag(String flagName) {
        Flag flag = new Flag();
        flag.setEnabled(this.evaluateDefaultFlagPredicate(flagName));
        flag.setStateValue(this.evaluateDefaultFlagValue(flagName));
        Feature feature = new Feature();
        feature.setName(flagName);
        flag.setFeature(feature);
        if (flag.getStateValue() == null) {
            feature.setType("FLAG");
        } else {
            feature.setType("CONFIG");
        }
        return flag;
    }
}

