/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.threads;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flagsmith.FlagsmithLogger;
import com.flagsmith.MapperFactory;
import com.flagsmith.interfaces.FlagsmithSdk;
import com.flagsmith.threads.RequestProcessor;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class AnalyticsProcessor {
    private final String analyticsEndpoint = "analytics/flags/";
    private Integer analyticsTimer = 10;
    private Map<Integer, Integer> analyticsData = new HashMap<Integer, Integer>();
    private FlagsmithSdk api;
    private Long nextFlush;
    private RequestProcessor requestProcessor;
    private HttpUrl analyticsUrl;
    FlagsmithLogger logger;

    public AnalyticsProcessor(OkHttpClient client) {
        this(null, client, null);
    }

    public AnalyticsProcessor(FlagsmithSdk api, OkHttpClient client) {
        this(api, client, new FlagsmithLogger());
    }

    public AnalyticsProcessor(FlagsmithSdk api, OkHttpClient client, FlagsmithLogger logger) {
        this(api, logger, new RequestProcessor(client, logger));
    }

    public AnalyticsProcessor(FlagsmithSdk api, FlagsmithLogger logger, RequestProcessor requestProcessor) {
        this.requestProcessor = requestProcessor;
        this.logger = logger;
        this.nextFlush = Instant.now().getEpochSecond() + (long)this.analyticsTimer.intValue();
        this.api = api;
    }

    private RequestProcessor getRequestProcessor() {
        if (this.requestProcessor != null) {
            return this.requestProcessor;
        }
        return this.api.getRequestor();
    }

    public void setLogger(FlagsmithLogger logger) {
        this.logger = logger;
    }

    private HttpUrl getAnalyticsUrl() {
        if (this.api != null) {
            this.analyticsUrl = this.api.getConfig().getBaseUri().newBuilder("analytics/flags/").build();
        }
        return this.analyticsUrl;
    }

    public void flush() {
        String response;
        if (this.analyticsData.isEmpty()) {
            return;
        }
        try {
            ObjectMapper mapper = MapperFactory.getMapper();
            response = mapper.writeValueAsString(this.analyticsData);
        }
        catch (JsonProcessingException jpe) {
            this.logger.error("Error parsing analytics data to JSON.", new Object[]{jpe});
            return;
        }
        MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)json, (String)response);
        Request request = this.api.newPostRequest(this.getAnalyticsUrl(), body);
        this.getRequestProcessor().executeAsync(request, Boolean.FALSE);
        this.analyticsData.clear();
        this.setNextFlush();
    }

    public void trackFeature(Integer featureId) {
        this.analyticsData.put(featureId, this.analyticsData.getOrDefault(featureId, 0) + 1);
        if (this.nextFlush.compareTo(Instant.now().getEpochSecond()) < 0) {
            this.flush();
        }
    }

    private void setNextFlush() {
        this.nextFlush = Instant.now().getEpochSecond() + (long)this.analyticsTimer.intValue();
    }

    public String getAnalyticsEndpoint() {
        return this.analyticsEndpoint;
    }

    public Integer getAnalyticsTimer() {
        return this.analyticsTimer;
    }

    public Map<Integer, Integer> getAnalyticsData() {
        return this.analyticsData;
    }

    public FlagsmithSdk getApi() {
        return this.api;
    }

    public Long getNextFlush() {
        return this.nextFlush;
    }

    public FlagsmithLogger getLogger() {
        return this.logger;
    }

    public void setAnalyticsTimer(Integer analyticsTimer) {
        this.analyticsTimer = analyticsTimer;
    }

    public void setAnalyticsData(Map<Integer, Integer> analyticsData) {
        this.analyticsData = analyticsData;
    }

    public void setApi(FlagsmithSdk api) {
        this.api = api;
    }

    public void setNextFlush(Long nextFlush) {
        this.nextFlush = nextFlush;
    }

    public void setRequestProcessor(RequestProcessor requestProcessor) {
        this.requestProcessor = requestProcessor;
    }

    public void setAnalyticsUrl(HttpUrl analyticsUrl) {
        this.analyticsUrl = analyticsUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalyticsProcessor)) {
            return false;
        }
        AnalyticsProcessor other = (AnalyticsProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$analyticsTimer = this.getAnalyticsTimer();
        Integer other$analyticsTimer = other.getAnalyticsTimer();
        if (this$analyticsTimer == null ? other$analyticsTimer != null : !((Object)this$analyticsTimer).equals(other$analyticsTimer)) {
            return false;
        }
        Long this$nextFlush = this.getNextFlush();
        Long other$nextFlush = other.getNextFlush();
        if (this$nextFlush == null ? other$nextFlush != null : !((Object)this$nextFlush).equals(other$nextFlush)) {
            return false;
        }
        String this$analyticsEndpoint = this.getAnalyticsEndpoint();
        String other$analyticsEndpoint = other.getAnalyticsEndpoint();
        if (this$analyticsEndpoint == null ? other$analyticsEndpoint != null : !this$analyticsEndpoint.equals(other$analyticsEndpoint)) {
            return false;
        }
        Map<Integer, Integer> this$analyticsData = this.getAnalyticsData();
        Map<Integer, Integer> other$analyticsData = other.getAnalyticsData();
        if (this$analyticsData == null ? other$analyticsData != null : !((Object)this$analyticsData).equals(other$analyticsData)) {
            return false;
        }
        FlagsmithSdk this$api = this.getApi();
        FlagsmithSdk other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        RequestProcessor this$requestProcessor = this.getRequestProcessor();
        RequestProcessor other$requestProcessor = other.getRequestProcessor();
        if (this$requestProcessor == null ? other$requestProcessor != null : !((Object)this$requestProcessor).equals(other$requestProcessor)) {
            return false;
        }
        HttpUrl this$analyticsUrl = this.getAnalyticsUrl();
        HttpUrl other$analyticsUrl = other.getAnalyticsUrl();
        if (this$analyticsUrl == null ? other$analyticsUrl != null : !this$analyticsUrl.equals(other$analyticsUrl)) {
            return false;
        }
        FlagsmithLogger this$logger = this.getLogger();
        FlagsmithLogger other$logger = other.getLogger();
        return !(this$logger == null ? other$logger != null : !this$logger.equals(other$logger));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnalyticsProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $analyticsTimer = this.getAnalyticsTimer();
        result = result * 59 + ($analyticsTimer == null ? 43 : ((Object)$analyticsTimer).hashCode());
        Long $nextFlush = this.getNextFlush();
        result = result * 59 + ($nextFlush == null ? 43 : ((Object)$nextFlush).hashCode());
        String $analyticsEndpoint = this.getAnalyticsEndpoint();
        result = result * 59 + ($analyticsEndpoint == null ? 43 : $analyticsEndpoint.hashCode());
        Map<Integer, Integer> $analyticsData = this.getAnalyticsData();
        result = result * 59 + ($analyticsData == null ? 43 : ((Object)$analyticsData).hashCode());
        FlagsmithSdk $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        RequestProcessor $requestProcessor = this.getRequestProcessor();
        result = result * 59 + ($requestProcessor == null ? 43 : ((Object)$requestProcessor).hashCode());
        HttpUrl $analyticsUrl = this.getAnalyticsUrl();
        result = result * 59 + ($analyticsUrl == null ? 43 : $analyticsUrl.hashCode());
        FlagsmithLogger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        return result;
    }

    public String toString() {
        return "AnalyticsProcessor(analyticsEndpoint=" + this.getAnalyticsEndpoint() + ", analyticsTimer=" + this.getAnalyticsTimer() + ", analyticsData=" + this.getAnalyticsData() + ", nextFlush=" + this.getNextFlush() + ", requestProcessor=" + this.getRequestProcessor() + ", analyticsUrl=" + this.getAnalyticsUrl() + ", logger=" + this.getLogger() + ")";
    }
}

