/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.threads;

import com.flagsmith.FlagsmithClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingManager {
    FlagsmithClient client;
    Integer interval;
    Thread internalThread;
    Logger logger = LoggerFactory.getLogger(PollingManager.class);

    public PollingManager(FlagsmithClient client) {
        this(client, 10);
    }

    public PollingManager(FlagsmithClient client, Integer interval) {
        this.client = client;
        this.interval = interval * 1000;
        this.internalThread = this.initializeThread();
    }

    private Thread initializeThread() {
        return new Thread(){

            @Override
            public void run() {
                try {
                    while (!this.isInterrupted()) {
                        PollingManager.this.client.updateEnvironment();
                        Thread.sleep(PollingManager.this.interval.intValue());
                    }
                }
                catch (InterruptedException e) {
                    PollingManager.this.logger.info("Polling manager interrupted. Automatic environment update will stop!");
                }
            }
        };
    }

    public void startPolling() {
        this.internalThread.start();
    }

    public void stopPolling() {
        this.internalThread.interrupt();
    }
}

