/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine.utils.types;

import com.flagsmith.flagengine.segments.constants.SegmentConditions;
import com.flagsmith.flagengine.utils.SemanticVersioning;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class TypeCasting {
    public static Boolean compare(SegmentConditions condition, Object value1, Object value2) {
        if (condition.equals((Object)SegmentConditions.MODULO)) {
            return TypeCasting.compareModulo(String.valueOf(value2), value1);
        }
        if (TypeCasting.isInteger(value1).booleanValue() && TypeCasting.isInteger(value2).booleanValue()) {
            return TypeCasting.compare(condition, TypeCasting.toInteger(value1), TypeCasting.toInteger(value2));
        }
        if (TypeCasting.isFloat(value1).booleanValue() && TypeCasting.isFloat(value2).booleanValue()) {
            return TypeCasting.compare(condition, TypeCasting.toFloat(value1), TypeCasting.toFloat(value2));
        }
        if (TypeCasting.isDouble(value1).booleanValue() && TypeCasting.isDouble(value2).booleanValue()) {
            return TypeCasting.compare(condition, TypeCasting.toDouble(value1), TypeCasting.toDouble(value2));
        }
        if (TypeCasting.isBoolean(value1).booleanValue() && TypeCasting.isBoolean(value2).booleanValue()) {
            return TypeCasting.compare(condition, TypeCasting.toBoolean(value1), TypeCasting.toBoolean(value2));
        }
        if (TypeCasting.isSemver(value2).booleanValue()) {
            return TypeCasting.compare(condition, (Comparable)TypeCasting.toSemver(value1), (Comparable)TypeCasting.toSemver(value2));
        }
        return TypeCasting.compare(condition, (Comparable)((Object)((String)value1)), (Comparable)((Object)((String)value2)));
    }

    public static Boolean compare(SegmentConditions condition, Comparable value1, Comparable value2) {
        if (condition.equals((Object)SegmentConditions.EQUAL)) {
            return value1.compareTo(value2) == 0;
        }
        if (condition.equals((Object)SegmentConditions.GREATER_THAN)) {
            return value1.compareTo(value2) > 0;
        }
        if (condition.equals((Object)SegmentConditions.GREATER_THAN_INCLUSIVE)) {
            return value1.compareTo(value2) >= 0;
        }
        if (condition.equals((Object)SegmentConditions.LESS_THAN)) {
            return value1.compareTo(value2) < 0;
        }
        if (condition.equals((Object)SegmentConditions.LESS_THAN_INCLUSIVE)) {
            return value1.compareTo(value2) <= 0;
        }
        if (condition.equals((Object)SegmentConditions.NOT_EQUAL)) {
            return value1.compareTo(value2) != 0;
        }
        if (condition.equals((Object)SegmentConditions.NOT_CONTAINS)) {
            return value1.compareTo(value2) != 0;
        }
        return value1.compareTo(value2) == 0;
    }

    public static Double toDouble(Object number) {
        try {
            String asString = String.valueOf(number);
            return number instanceof Double ? (Double)number : Double.parseDouble(asString);
        }
        catch (Exception nfe) {
            return null;
        }
    }

    public static Boolean isDouble(Object number) {
        return number instanceof Float || TypeCasting.toDouble(number) != null;
    }

    public static Float toFloat(Object number) {
        try {
            return Float.valueOf(number instanceof Float ? ((Float)number).floatValue() : Float.parseFloat(String.valueOf(number)));
        }
        catch (Exception nfe) {
            return null;
        }
    }

    public static Boolean isFloat(Object number) {
        return number instanceof Float || TypeCasting.toFloat(number) != null;
    }

    public static Integer toInteger(Object number) {
        try {
            String asString = String.valueOf(number);
            return number instanceof Integer ? (Integer)number : Integer.valueOf(asString);
        }
        catch (Exception nfe) {
            return null;
        }
    }

    public static Boolean isInteger(Object number) {
        return number instanceof Integer || TypeCasting.toInteger(number) != null;
    }

    public static Boolean toBoolean(Object str) {
        try {
            return str instanceof Boolean ? (Boolean)str : BooleanUtils.toBoolean((String)((String)str));
        }
        catch (Exception nfe) {
            return null;
        }
    }

    public static Boolean isBoolean(Object str) {
        return str instanceof Boolean || Boolean.TRUE.toString().equalsIgnoreCase((String)str) || Boolean.FALSE.toString().equalsIgnoreCase((String)str);
    }

    public static ComparableVersion toSemver(Object str) {
        try {
            String value = SemanticVersioning.isSemver((String)str) != false ? SemanticVersioning.removeSemver((String)str) : (String)str;
            return new ComparableVersion(value);
        }
        catch (Exception nfe) {
            return null;
        }
    }

    public static Boolean isSemver(Object str) {
        return SemanticVersioning.isSemver((String)str);
    }

    public static Boolean compareModulo(String conditionValue, Object traitValue) {
        try {
            String[] divisorAndRemainder = conditionValue.split("\\|");
            Float divisor = TypeCasting.toFloat(divisorAndRemainder[0]);
            Float remainder = TypeCasting.toFloat(divisorAndRemainder[1]);
            return TypeCasting.toFloat(traitValue).floatValue() % divisor.floatValue() == remainder.floatValue();
        }
        catch (NullPointerException | NumberFormatException e) {
            return false;
        }
    }
}

