/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.config;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

public class Retry {
    private Integer total = 1;
    private Integer attempts = 0;
    private Float backoffFactor = Float.valueOf(0.1f);
    private Float backoffMax = Float.valueOf(15.0f);
    private Set<Integer> statusForcelist = new HashSet<Integer>(){
        {
            this.add(413);
            this.add(429);
            this.add(503);
        }
    };

    public Retry(Integer total) {
        this.total = total;
    }

    public Boolean isRetry(Integer statusCode) {
        if (this.statusForcelist != null && !this.statusForcelist.isEmpty() && this.statusForcelist.contains(statusCode)) {
            return Boolean.TRUE;
        }
        return this.total > this.attempts;
    }

    public Long calculateSleepTime() {
        Float holdTimeMs = Float.valueOf(this.backoffFactor.floatValue() * (float)(2 * this.attempts));
        if (holdTimeMs.floatValue() >= this.backoffMax.floatValue()) {
            holdTimeMs = this.backoffMax;
        }
        return Float.valueOf(holdTimeMs.floatValue() * 1000.0f).longValue();
    }

    public void waitWithBackoff() throws InterruptedException {
        Thread.sleep(this.calculateSleepTime());
    }

    public void retryAttempted() {
        Integer n = this.attempts;
        this.attempts = this.attempts + 1;
    }

    @Generated
    public static RetryBuilder builder() {
        return new RetryBuilder();
    }

    @Generated
    public RetryBuilder toBuilder() {
        return new RetryBuilder().total(this.total).attempts(this.attempts).backoffFactor(this.backoffFactor).backoffMax(this.backoffMax).statusForcelist(this.statusForcelist);
    }

    @Generated
    public Integer getTotal() {
        return this.total;
    }

    @Generated
    public Integer getAttempts() {
        return this.attempts;
    }

    @Generated
    public Float getBackoffFactor() {
        return this.backoffFactor;
    }

    @Generated
    public Float getBackoffMax() {
        return this.backoffMax;
    }

    @Generated
    public Set<Integer> getStatusForcelist() {
        return this.statusForcelist;
    }

    @Generated
    public void setTotal(Integer total) {
        this.total = total;
    }

    @Generated
    public void setAttempts(Integer attempts) {
        this.attempts = attempts;
    }

    @Generated
    public void setBackoffFactor(Float backoffFactor) {
        this.backoffFactor = backoffFactor;
    }

    @Generated
    public void setBackoffMax(Float backoffMax) {
        this.backoffMax = backoffMax;
    }

    @Generated
    public void setStatusForcelist(Set<Integer> statusForcelist) {
        this.statusForcelist = statusForcelist;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Retry)) {
            return false;
        }
        Retry other = (Retry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$total = this.getTotal();
        Integer other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Integer this$attempts = this.getAttempts();
        Integer other$attempts = other.getAttempts();
        if (this$attempts == null ? other$attempts != null : !((Object)this$attempts).equals(other$attempts)) {
            return false;
        }
        Float this$backoffFactor = this.getBackoffFactor();
        Float other$backoffFactor = other.getBackoffFactor();
        if (this$backoffFactor == null ? other$backoffFactor != null : !((Object)this$backoffFactor).equals(other$backoffFactor)) {
            return false;
        }
        Float this$backoffMax = this.getBackoffMax();
        Float other$backoffMax = other.getBackoffMax();
        if (this$backoffMax == null ? other$backoffMax != null : !((Object)this$backoffMax).equals(other$backoffMax)) {
            return false;
        }
        Set<Integer> this$statusForcelist = this.getStatusForcelist();
        Set<Integer> other$statusForcelist = other.getStatusForcelist();
        return !(this$statusForcelist == null ? other$statusForcelist != null : !((Object)this$statusForcelist).equals(other$statusForcelist));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Retry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Integer $attempts = this.getAttempts();
        result = result * 59 + ($attempts == null ? 43 : ((Object)$attempts).hashCode());
        Float $backoffFactor = this.getBackoffFactor();
        result = result * 59 + ($backoffFactor == null ? 43 : ((Object)$backoffFactor).hashCode());
        Float $backoffMax = this.getBackoffMax();
        result = result * 59 + ($backoffMax == null ? 43 : ((Object)$backoffMax).hashCode());
        Set<Integer> $statusForcelist = this.getStatusForcelist();
        result = result * 59 + ($statusForcelist == null ? 43 : ((Object)$statusForcelist).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Retry(total=" + this.getTotal() + ", attempts=" + this.getAttempts() + ", backoffFactor=" + this.getBackoffFactor() + ", backoffMax=" + this.getBackoffMax() + ", statusForcelist=" + this.getStatusForcelist() + ")";
    }

    @Generated
    public Retry() {
    }

    @Generated
    public Retry(Integer total, Integer attempts, Float backoffFactor, Float backoffMax, Set<Integer> statusForcelist) {
        this.total = total;
        this.attempts = attempts;
        this.backoffFactor = backoffFactor;
        this.backoffMax = backoffMax;
        this.statusForcelist = statusForcelist;
    }

    @Generated
    public static class RetryBuilder {
        @Generated
        private Integer total;
        @Generated
        private Integer attempts;
        @Generated
        private Float backoffFactor;
        @Generated
        private Float backoffMax;
        @Generated
        private Set<Integer> statusForcelist;

        @Generated
        RetryBuilder() {
        }

        @Generated
        public RetryBuilder total(Integer total) {
            this.total = total;
            return this;
        }

        @Generated
        public RetryBuilder attempts(Integer attempts) {
            this.attempts = attempts;
            return this;
        }

        @Generated
        public RetryBuilder backoffFactor(Float backoffFactor) {
            this.backoffFactor = backoffFactor;
            return this;
        }

        @Generated
        public RetryBuilder backoffMax(Float backoffMax) {
            this.backoffMax = backoffMax;
            return this;
        }

        @Generated
        public RetryBuilder statusForcelist(Set<Integer> statusForcelist) {
            this.statusForcelist = statusForcelist;
            return this;
        }

        @Generated
        public Retry build() {
            return new Retry(this.total, this.attempts, this.backoffFactor, this.backoffMax, this.statusForcelist);
        }

        @Generated
        public String toString() {
            return "Retry.RetryBuilder(total=" + this.total + ", attempts=" + this.attempts + ", backoffFactor=" + this.backoffFactor + ", backoffMax=" + this.backoffMax + ", statusForcelist=" + this.statusForcelist + ")";
        }
    }
}

