/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine.identities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.flagsmith.flagengine.features.FeatureStateModel;
import com.flagsmith.flagengine.identities.traits.TraitModel;
import com.flagsmith.utils.models.BaseModel;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;

public class IdentityModel
extends BaseModel {
    @JsonProperty(value="django_id")
    private Integer djangoId;
    private String identifier;
    @JsonProperty(value="environment_api_key")
    private String environmentApiKey;
    @JsonProperty(value="created_date")
    private Date createdDate;
    @JsonProperty(value="identity_uuid")
    private String identityUuid = UUID.randomUUID().toString();
    @JsonProperty(value="identity_traits")
    private List<? extends TraitModel> identityTraits = new ArrayList<TraitModel>();
    @JsonProperty(value="identity_features")
    private List<FeatureStateModel> identityFeatures = new ArrayList<FeatureStateModel>();
    @JsonProperty(value="composite_key")
    private String compositeKey;

    public String getCompositeKey() {
        if (this.compositeKey == null) {
            this.compositeKey = this.environmentApiKey + "_" + this.identifier;
        }
        return this.compositeKey;
    }

    public void updateTraits(List<? extends TraitModel> traits) {
        Map<Object, Object> existingTraits = new HashMap();
        if (this.identityTraits != null && this.identityTraits.size() > 0) {
            existingTraits = this.identityTraits.stream().collect(Collectors.toMap(TraitModel::getTraitKey, trait -> trait));
        }
        for (TraitModel traitModel : traits) {
            if (traitModel.getTraitValue() == null) {
                existingTraits.remove(traitModel.getTraitKey());
                continue;
            }
            existingTraits.put(traitModel.getTraitKey(), traitModel);
        }
        this.identityTraits = existingTraits.values().stream().collect(Collectors.toList());
    }

    @Generated
    public IdentityModel() {
    }

    @Generated
    public Integer getDjangoId() {
        return this.djangoId;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getEnvironmentApiKey() {
        return this.environmentApiKey;
    }

    @Generated
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public String getIdentityUuid() {
        return this.identityUuid;
    }

    @Generated
    public List<? extends TraitModel> getIdentityTraits() {
        return this.identityTraits;
    }

    @Generated
    public List<FeatureStateModel> getIdentityFeatures() {
        return this.identityFeatures;
    }

    @JsonProperty(value="django_id")
    @Generated
    public void setDjangoId(Integer djangoId) {
        this.djangoId = djangoId;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="environment_api_key")
    @Generated
    public void setEnvironmentApiKey(String environmentApiKey) {
        this.environmentApiKey = environmentApiKey;
    }

    @JsonProperty(value="created_date")
    @Generated
    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @JsonProperty(value="identity_uuid")
    @Generated
    public void setIdentityUuid(String identityUuid) {
        this.identityUuid = identityUuid;
    }

    @JsonProperty(value="identity_traits")
    @Generated
    public void setIdentityTraits(List<? extends TraitModel> identityTraits) {
        this.identityTraits = identityTraits;
    }

    @JsonProperty(value="identity_features")
    @Generated
    public void setIdentityFeatures(List<FeatureStateModel> identityFeatures) {
        this.identityFeatures = identityFeatures;
    }

    @JsonProperty(value="composite_key")
    @Generated
    public void setCompositeKey(String compositeKey) {
        this.compositeKey = compositeKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdentityModel)) {
            return false;
        }
        IdentityModel other = (IdentityModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$djangoId = this.getDjangoId();
        Integer other$djangoId = other.getDjangoId();
        if (this$djangoId == null ? other$djangoId != null : !((Object)this$djangoId).equals(other$djangoId)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$environmentApiKey = this.getEnvironmentApiKey();
        String other$environmentApiKey = other.getEnvironmentApiKey();
        if (this$environmentApiKey == null ? other$environmentApiKey != null : !this$environmentApiKey.equals(other$environmentApiKey)) {
            return false;
        }
        Date this$createdDate = this.getCreatedDate();
        Date other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        String this$identityUuid = this.getIdentityUuid();
        String other$identityUuid = other.getIdentityUuid();
        if (this$identityUuid == null ? other$identityUuid != null : !this$identityUuid.equals(other$identityUuid)) {
            return false;
        }
        List<? extends TraitModel> this$identityTraits = this.getIdentityTraits();
        List<? extends TraitModel> other$identityTraits = other.getIdentityTraits();
        if (this$identityTraits == null ? other$identityTraits != null : !((Object)this$identityTraits).equals(other$identityTraits)) {
            return false;
        }
        List<FeatureStateModel> this$identityFeatures = this.getIdentityFeatures();
        List<FeatureStateModel> other$identityFeatures = other.getIdentityFeatures();
        if (this$identityFeatures == null ? other$identityFeatures != null : !((Object)this$identityFeatures).equals(other$identityFeatures)) {
            return false;
        }
        String this$compositeKey = this.getCompositeKey();
        String other$compositeKey = other.getCompositeKey();
        return !(this$compositeKey == null ? other$compositeKey != null : !this$compositeKey.equals(other$compositeKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IdentityModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $djangoId = this.getDjangoId();
        result = result * 59 + ($djangoId == null ? 43 : ((Object)$djangoId).hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $environmentApiKey = this.getEnvironmentApiKey();
        result = result * 59 + ($environmentApiKey == null ? 43 : $environmentApiKey.hashCode());
        Date $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        String $identityUuid = this.getIdentityUuid();
        result = result * 59 + ($identityUuid == null ? 43 : $identityUuid.hashCode());
        List<? extends TraitModel> $identityTraits = this.getIdentityTraits();
        result = result * 59 + ($identityTraits == null ? 43 : ((Object)$identityTraits).hashCode());
        List<FeatureStateModel> $identityFeatures = this.getIdentityFeatures();
        result = result * 59 + ($identityFeatures == null ? 43 : ((Object)$identityFeatures).hashCode());
        String $compositeKey = this.getCompositeKey();
        result = result * 59 + ($compositeKey == null ? 43 : $compositeKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IdentityModel(super=" + super.toString() + ", djangoId=" + this.getDjangoId() + ", identifier=" + this.getIdentifier() + ", environmentApiKey=" + this.getEnvironmentApiKey() + ", createdDate=" + this.getCreatedDate() + ", identityUuid=" + this.getIdentityUuid() + ", identityTraits=" + this.getIdentityTraits() + ", identityFeatures=" + this.getIdentityFeatures() + ", compositeKey=" + this.getCompositeKey() + ")";
    }
}

