
package com.flagsmith.flagengine;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * EnvironmentContext
 * <p>
 * Represents an environment context for feature flag evaluation.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "key",
    "name"
})
@Generated("jsonschema2pojo")
public class EnvironmentContext {

    /**
     * Key
     * <p>
     * Unique environment key. May be used for selecting a value for a multivariate feature, or for % split segmentation.
     * (Required)
     * 
     */
    @JsonProperty("key")
    @JsonPropertyDescription("Unique environment key. May be used for selecting a value for a multivariate feature, or for % split segmentation.")
    private String key;
    /**
     * Name
     * <p>
     * An environment's human-readable name.
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("An environment's human-readable name.")
    private String name;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public EnvironmentContext() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public EnvironmentContext(EnvironmentContext source) {
        super();
        this.key = source.key;
        this.name = source.name;
    }

    /**
     * 
     * @param name
     *     Name. An environment's human-readable name.
     * @param key
     *     Key. Unique environment key. May be used for selecting a value for a multivariate feature, or for % split segmentation.
     */
    public EnvironmentContext(String key, String name) {
        super();
        this.key = key;
        this.name = name;
    }

    /**
     * Key
     * <p>
     * Unique environment key. May be used for selecting a value for a multivariate feature, or for % split segmentation.
     * (Required)
     * 
     */
    @JsonProperty("key")
    public String getKey() {
        return key;
    }

    /**
     * Key
     * <p>
     * Unique environment key. May be used for selecting a value for a multivariate feature, or for % split segmentation.
     * (Required)
     * 
     */
    @JsonProperty("key")
    public void setKey(String key) {
        this.key = key;
    }

    public EnvironmentContext withKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Name
     * <p>
     * An environment's human-readable name.
     * (Required)
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Name
     * <p>
     * An environment's human-readable name.
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public EnvironmentContext withName(String name) {
        this.name = name;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public EnvironmentContext withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EnvironmentContext.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("key");
        sb.append('=');
        sb.append(((this.key == null)?"<null>":this.key));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.key == null)? 0 :this.key.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof EnvironmentContext) == false) {
            return false;
        }
        EnvironmentContext rhs = ((EnvironmentContext) other);
        return ((((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.key == rhs.key)||((this.key!= null)&&this.key.equals(rhs.key))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
