
package com.flagsmith.flagengine;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * EvaluationContext
 * <p>
 * A context object containing the necessary information to evaluate Flagsmith feature flags.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "environment",
    "identity",
    "segments",
    "features"
})
@Generated("jsonschema2pojo")
public class EvaluationContext {

    /**
     * EnvironmentContext
     * <p>
     * Represents an environment context for feature flag evaluation.
     * (Required)
     * 
     */
    @JsonProperty("environment")
    @JsonPropertyDescription("Represents an environment context for feature flag evaluation.")
    private EnvironmentContext environment;
    /**
     * Identity context used for identity-based evaluation.
     * 
     */
    @JsonProperty("identity")
    @JsonPropertyDescription("Identity context used for identity-based evaluation.")
    private IdentityContext identity = null;
    /**
     * Segments
     * <p>
     * Segments applicable to the evaluation context.
     * 
     */
    @JsonProperty("segments")
    @JsonPropertyDescription("Segments applicable to the evaluation context.")
    private Segments segments;
    /**
     * Features
     * <p>
     * Features to be evaluated in the context.
     * 
     */
    @JsonProperty("features")
    @JsonPropertyDescription("Features to be evaluated in the context.")
    private Features features;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public EvaluationContext() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public EvaluationContext(EvaluationContext source) {
        super();
        this.environment = source.environment;
        this.identity = source.identity;
        this.segments = source.segments;
        this.features = source.features;
    }

    /**
     * 
     * @param features
     *     Features. Features to be evaluated in the context.
     * @param environment
     *     Environment context required for evaluation.
     * @param identity
     *     Identity context used for identity-based evaluation.
     * @param segments
     *     Segments. Segments applicable to the evaluation context.
     */
    public EvaluationContext(EnvironmentContext environment, IdentityContext identity, Segments segments, Features features) {
        super();
        this.environment = environment;
        this.identity = identity;
        this.segments = segments;
        this.features = features;
    }

    /**
     * EnvironmentContext
     * <p>
     * Represents an environment context for feature flag evaluation.
     * (Required)
     * 
     */
    @JsonProperty("environment")
    public EnvironmentContext getEnvironment() {
        return environment;
    }

    /**
     * EnvironmentContext
     * <p>
     * Represents an environment context for feature flag evaluation.
     * (Required)
     * 
     */
    @JsonProperty("environment")
    public void setEnvironment(EnvironmentContext environment) {
        this.environment = environment;
    }

    public EvaluationContext withEnvironment(EnvironmentContext environment) {
        this.environment = environment;
        return this;
    }

    /**
     * Identity context used for identity-based evaluation.
     * 
     */
    @JsonProperty("identity")
    public IdentityContext getIdentity() {
        return identity;
    }

    /**
     * Identity context used for identity-based evaluation.
     * 
     */
    @JsonProperty("identity")
    public void setIdentity(IdentityContext identity) {
        this.identity = identity;
    }

    public EvaluationContext withIdentity(IdentityContext identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Segments
     * <p>
     * Segments applicable to the evaluation context.
     * 
     */
    @JsonProperty("segments")
    public Segments getSegments() {
        return segments;
    }

    /**
     * Segments
     * <p>
     * Segments applicable to the evaluation context.
     * 
     */
    @JsonProperty("segments")
    public void setSegments(Segments segments) {
        this.segments = segments;
    }

    public EvaluationContext withSegments(Segments segments) {
        this.segments = segments;
        return this;
    }

    /**
     * Features
     * <p>
     * Features to be evaluated in the context.
     * 
     */
    @JsonProperty("features")
    public Features getFeatures() {
        return features;
    }

    /**
     * Features
     * <p>
     * Features to be evaluated in the context.
     * 
     */
    @JsonProperty("features")
    public void setFeatures(Features features) {
        this.features = features;
    }

    public EvaluationContext withFeatures(Features features) {
        this.features = features;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public EvaluationContext withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EvaluationContext.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("environment");
        sb.append('=');
        sb.append(((this.environment == null)?"<null>":this.environment));
        sb.append(',');
        sb.append("identity");
        sb.append('=');
        sb.append(((this.identity == null)?"<null>":this.identity));
        sb.append(',');
        sb.append("segments");
        sb.append('=');
        sb.append(((this.segments == null)?"<null>":this.segments));
        sb.append(',');
        sb.append("features");
        sb.append('=');
        sb.append(((this.features == null)?"<null>":this.features));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.features == null)? 0 :this.features.hashCode()));
        result = ((result* 31)+((this.environment == null)? 0 :this.environment.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.identity == null)? 0 :this.identity.hashCode()));
        result = ((result* 31)+((this.segments == null)? 0 :this.segments.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof EvaluationContext) == false) {
            return false;
        }
        EvaluationContext rhs = ((EvaluationContext) other);
        return ((((((this.features == rhs.features)||((this.features!= null)&&this.features.equals(rhs.features)))&&((this.environment == rhs.environment)||((this.environment!= null)&&this.environment.equals(rhs.environment))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.identity == rhs.identity)||((this.identity!= null)&&this.identity.equals(rhs.identity))))&&((this.segments == rhs.segments)||((this.segments!= null)&&this.segments.equals(rhs.segments))));
    }

}
